/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.fluids;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import xxrexraptorxx.minetraps.blocks.BlockToxin;
import xxrexraptorxx.minetraps.fluids.ModFluidTypes;
import xxrexraptorxx.minetraps.registry.ModBlocks;
import xxrexraptorxx.minetraps.registry.ModFluids;
import xxrexraptorxx.minetraps.registry.ModItems;

public abstract class ToxinFluid
extends FlowingFluid {
    @NotNull
    public Fluid getFlowing() {
        return (Fluid)ModFluids.FLOWING_TOXIN.get();
    }

    @NotNull
    public Fluid getSource() {
        return (Fluid)ModFluids.TOXIN.get();
    }

    @NotNull
    public Item getBucket() {
        return (Item)ModItems.TOXIN_BUCKET.get();
    }

    public void animateTick(@NotNull Level level, @NotNull BlockPos blockPos, FluidState fluidState, @NotNull RandomSource randomSource) {
        if (!fluidState.isSource() && !((Boolean)fluidState.getValue((Property)FALLING)).booleanValue()) {
            if (randomSource.nextInt(64) == 0) {
                level.playLocalSound((double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5, SoundEvents.WATER_AMBIENT, SoundSource.BLOCKS, randomSource.nextFloat() * 0.25f + 0.75f, randomSource.nextFloat() + 0.5f, false);
            }
        } else if (randomSource.nextInt(10) == 0) {
            level.addParticle((ParticleOptions)ParticleTypes.UNDERWATER, (double)blockPos.getX() + randomSource.nextDouble(), (double)blockPos.getY() + randomSource.nextDouble(), (double)blockPos.getZ() + randomSource.nextDouble(), 0.0, 0.0, 0.0);
        }
    }

    @NotNull
    public FluidType getFluidType() {
        return (FluidType)ModFluidTypes.TOXIN_FLUID_TYPE.value();
    }

    @Nullable
    public ParticleOptions getDripParticle() {
        return ParticleTypes.DRIPPING_WATER;
    }

    protected boolean canConvertToSource(@NotNull ServerLevel serverLevel) {
        return false;
    }

    protected void beforeDestroyingBlock(@NotNull LevelAccessor level, @NotNull BlockPos pos, BlockState state) {
        BlockEntity blockentity = state.hasBlockEntity() ? level.getBlockEntity(pos) : null;
        Block.dropResources((BlockState)state, (LevelAccessor)level, (BlockPos)pos, (BlockEntity)blockentity);
    }

    public int getSlopeFindDistance(@NotNull LevelReader level) {
        return 4;
    }

    @NotNull
    public BlockState createLegacyBlock(@NotNull FluidState state) {
        return (BlockState)((BlockToxin)((Object)ModBlocks.TOXIN.get())).defaultBlockState().setValue((Property)LiquidBlock.LEVEL, (Comparable)Integer.valueOf(ToxinFluid.getLegacyLevel((FluidState)state)));
    }

    public boolean isSame(@NotNull Fluid fluid) {
        return fluid == ModFluids.TOXIN.get() || fluid == ModFluids.FLOWING_TOXIN.get();
    }

    public int getDropOff(@NotNull LevelReader level) {
        return 2;
    }

    public int getTickDelay(@NotNull LevelReader levelReader) {
        return 5;
    }

    public boolean canBeReplacedWith(@NotNull FluidState fluidState, @NotNull BlockGetter blockReader, @NotNull BlockPos pos, @NotNull Fluid fluid, @NotNull Direction direction) {
        return direction == Direction.DOWN && !fluid.is(FluidTags.WATER);
    }

    protected float getExplosionResistance() {
        return 100.0f;
    }

    @NotNull
    public Optional<SoundEvent> getPickupSound() {
        return Optional.of(SoundEvents.BUCKET_FILL);
    }

    public static class Source
    extends ToxinFluid {
        public int getAmount(@NotNull FluidState state) {
            return 8;
        }

        public boolean isSource(@NotNull FluidState state) {
            return true;
        }
    }

    public static class Flowing
    extends ToxinFluid {
        protected void createFluidStateDefinition(StateDefinition.Builder<Fluid, FluidState> builder) {
            super.createFluidStateDefinition(builder);
            builder.add(new Property[]{LEVEL});
        }

        public int getAmount(FluidState state) {
            return (Integer)state.getValue((Property)LEVEL);
        }

        public boolean isSource(@NotNull FluidState state) {
            return false;
        }
    }
}

