/*
 * Decompiled with CFR 0.152.
 */
package xxrexraptorxx.minetraps.items;

import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.ItemUtils;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.Consumable;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemToxinBottle
extends Item {
    public static final FoodProperties TOXIN_BOTTLE_FOOD = new FoodProperties.Builder().build();
    public static final Consumable TOXIN_BOTTLE_CONSUMABLE = Consumable.builder().consumeSeconds(1.6f).animation(ItemUseAnimation.DRINK).sound((Holder)SoundEvents.GENERIC_DRINK).soundAfterConsume((Holder)SoundEvents.GENERIC_DRINK).hasConsumeParticles(false).build();

    public ItemToxinBottle(Item.Properties properties) {
        super(properties.stacksTo(4).craftRemainder(Items.GLASS_BOTTLE));
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        Player playerEntity;
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            CriteriaTriggers.CONSUME_ITEM.trigger(serverPlayer, stack);
            serverPlayer.awardStat(Stats.ITEM_USED.get((Object)this));
        }
        if (!level.isClientSide()) {
            livingEntity.addEffect(new MobEffectInstance(MobEffects.POISON, 800, 1));
            livingEntity.addEffect(new MobEffectInstance(MobEffects.NAUSEA, 400, 1));
        }
        super.finishUsingItem(stack, level, livingEntity);
        if (livingEntity instanceof Player && !(playerEntity = (Player)livingEntity).isCreative()) {
            if (!stack.isEmpty()) {
                ItemStack itemStack = new ItemStack((ItemLike)Items.GLASS_BOTTLE);
                if (!playerEntity.getInventory().add(itemStack)) {
                    playerEntity.drop(itemStack, false);
                }
            } else {
                return new ItemStack((ItemLike)Items.GLASS_BOTTLE);
            }
        }
        return stack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity user) {
        return TOXIN_BOTTLE_CONSUMABLE.consumeTicks();
    }

    @NotNull
    public ItemUseAnimation getUseAnimation(@NotNull ItemStack stack) {
        return ItemUseAnimation.DRINK;
    }

    @NotNull
    public InteractionResult use(@NotNull Level level, @NotNull Player player, @NotNull InteractionHand hand) {
        return ItemUtils.startUsingInstantly((Level)level, (Player)player, (InteractionHand)hand);
    }
}

