/*
 * Decompiled with CFR 0.152.
 */
package fr.iamacat.mycoordinatesmods.eventhandler;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import fr.iamacat.mycoordinatesmods.config.CoordinatesConfig;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraftforge.client.event.RenderGameOverlayEvent;

public class CoordinatesEventHandler {
    public static boolean showCoordinates = true;
    private final String[] cardinalPoints = new String[]{"N", "NE", "E", "SE", "S", "SW", "W", "NW"};

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.TEXT) {
            return;
        }
        Minecraft minecraft = Minecraft.func_71410_x();
        if (showCoordinates && !minecraft.field_71474_y.field_74330_P) {
            int yCoord;
            int xCoord;
            FontRenderer fontRenderer = minecraft.field_71466_p;
            ScaledResolution scaledResolution = event.resolution;
            boolean isTop = false;
            switch (CoordinatesConfig.hudPosition) {
                case "top_left": {
                    xCoord = 2;
                    yCoord = 2;
                    isTop = true;
                    break;
                }
                case "top_right": {
                    xCoord = scaledResolution.func_78326_a() - 2 - fontRenderer.func_78256_a("X: 0000.00");
                    yCoord = 2;
                    isTop = true;
                    break;
                }
                case "bottom_left": {
                    xCoord = 2;
                    yCoord = scaledResolution.func_78328_b() - 10;
                    break;
                }
                default: {
                    xCoord = scaledResolution.func_78326_a() - 2 - fontRenderer.func_78256_a("X: 0000.00");
                    yCoord = scaledResolution.func_78328_b() - 10;
                }
            }
            if (!CoordinatesConfig.disableXCoord) {
                String x = String.format("%.2f", minecraft.field_71439_g.field_70165_t);
                fontRenderer.func_78276_b("X: " + x, xCoord, yCoord, 0xFFFFFF);
                yCoord += isTop ? 10 : -10;
            }
            if (!CoordinatesConfig.disableYCoord) {
                String y = String.format("%.2f", minecraft.field_71439_g.field_70163_u);
                fontRenderer.func_78276_b("Y: " + y, xCoord, yCoord, 0xFFFFFF);
                yCoord += isTop ? 10 : -10;
            }
            if (!CoordinatesConfig.disableZCoord) {
                String z = String.format("%.2f", minecraft.field_71439_g.field_70161_v);
                fontRenderer.func_78276_b("Z: " + z, xCoord, yCoord, 0xFFFFFF);
                yCoord += isTop ? 10 : -10;
            }
            if (!CoordinatesConfig.disableFacing) {
                String facing = this.getCardinalPoint(minecraft.field_71439_g.field_70177_z);
                fontRenderer.func_78276_b("Facing: " + facing, xCoord, yCoord, 0xFFFFFF);
                yCoord += isTop ? 10 : -10;
            }
            if (!CoordinatesConfig.disableFPSCounter) {
                String fps = minecraft.field_71426_K.split(" ")[0];
                fontRenderer.func_78276_b("FPS: " + fps, xCoord, yCoord, 0xFFFFFF);
            }
        }
    }

    private String getCardinalPoint(float yaw) {
        yaw = (yaw % 360.0f + 360.0f) % 360.0f;
        int index = (int)(((double)yaw + 22.5) / 45.0) % 8;
        return this.cardinalPoints[index];
    }
}

