/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary;

import io.github.sakurawald.Fuji;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.manager.impl.module.ModuleManager;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public final class ReflectionUtil {
    public static final String MODULE_INITIALIZER_GRAPH_FILE_NAME = "module-initializer-graph.txt";
    public static final String ARGUMENT_TYPE_ADAPTER_GRAPH_FILE_NAME = "argument-type-adapter-graph.txt";
    public static final String LANGUAGE_GRAPH_FILE_NAME = "language-graph.txt";
    public static final String MODULE_GRAPH_FILE_NAME = "module-graph.txt";

    public static List<Method> getMethodsWithAnnotation(Class<?> clazz, Class<? extends Annotation> annotation) {
        return Arrays.stream(clazz.getDeclaredMethods()).filter(it -> it.isAnnotationPresent(annotation)).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> getGraph(String graphName) {
        ArrayList<String> arrayList;
        block8: {
            InputStream inputStream = ReflectionUtil.class.getResourceAsStream(graphName);
            if (inputStream == null) {
                LogUtil.info("The inputStream of {} is null, we just simply return an empty graph for that.", graphName);
                return new ArrayList<String>();
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                String line;
                ArrayList<String> lines = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    lines.add(line);
                }
                arrayList = lines;
                if (Collections.singletonList(reader).get(0) == null) break block8;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
                throw throwable;
            }
            reader.close();
        }
        return arrayList;
    }

    public static Path computeModuleConfigPath(Class<?> clazz) {
        String modulePath = ModuleManager.computeModulePathAsString(clazz.getName());
        return ReflectionUtil.computeModuleConfigPath(modulePath);
    }

    public static Path computeModuleConfigPath(String modulePath) {
        String others = modulePath.replace(".", "/");
        return Fuji.CONFIG_PATH.resolve("modules").resolve(others);
    }

    public static boolean isWrapperType(Type type) {
        return type == Integer.class || type == Float.class || type == Byte.class || type == Double.class || type == Long.class || type == Character.class || type == Boolean.class || type == Short.class || type == Void.class;
    }

    public static List<String> getStackTraceAsList(Throwable throwable) {
        return Arrays.stream(throwable.getStackTrace()).map(StackTraceElement::toString).collect(Collectors.toList());
    }

    private ReflectionUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

