/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import lombok.NonNull;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.model.user.UserManager;
import net.luckperms.api.util.Tristate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PermissionHelper {
    private static LuckPerms instance;

    @Nullable
    private static LuckPerms getAPI() {
        if (instance == null) {
            try {
                instance = LuckPermsProvider.get();
            }
            catch (Exception e) {
                return null;
            }
            return instance;
        }
        return instance;
    }

    private static User loadUser(@NonNull LuckPerms api, UUID uuid) {
        if (api == null) {
            throw new NullPointerException("api is marked non-null but is null");
        }
        UserManager userManager = api.getUserManager();
        if (userManager.isLoaded(uuid)) {
            return userManager.getUser(uuid);
        }
        CompletableFuture userFuture = userManager.loadUser(uuid);
        return (User)userFuture.join();
    }

    @NotNull
    public static Tristate getPermission(@NotNull UUID uuid, @Nullable String permission) {
        if (permission == null) {
            return Tristate.FALSE;
        }
        if (permission.isBlank()) {
            return Tristate.FALSE;
        }
        LuckPerms api = PermissionHelper.getAPI();
        if (api == null) {
            return Tristate.UNDEFINED;
        }
        User user = PermissionHelper.loadUser(api, uuid);
        return user.getCachedData().getPermissionData().checkPermission(permission);
    }

    public static boolean hasPermission(UUID uuid, @Nullable String permission) {
        return PermissionHelper.getPermission(uuid, permission).asBoolean();
    }

    @NonNull
    public static <T> Optional<T> getMeta(@NotNull UUID uuid, @Nullable String meta, @NonNull Function<String, ? extends T> valueTransformer) {
        if (valueTransformer == null) {
            throw new NullPointerException("valueTransformer is marked non-null but is null");
        }
        if (meta == null) {
            return Optional.empty();
        }
        LuckPerms api = PermissionHelper.getAPI();
        if (api == null) {
            return Optional.empty();
        }
        User user = PermissionHelper.loadUser(api, uuid);
        return user.getCachedData().getMetaData().getMetaValue(meta, valueTransformer);
    }

    @Nullable
    public static String getPrefix(UUID uuid) {
        LuckPerms api = PermissionHelper.getAPI();
        if (api == null) {
            return null;
        }
        User user = PermissionHelper.loadUser(api, uuid);
        return user.getCachedData().getMetaData().getPrefix();
    }

    @Nullable
    public static String getSuffix(UUID uuid) {
        LuckPerms api = PermissionHelper.getAPI();
        if (api == null) {
            return null;
        }
        User user = PermissionHelper.loadUser(api, uuid);
        return user.getCachedData().getMetaData().getSuffix();
    }

    private PermissionHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

