/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_8791;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PlayerHelper {
    private static final String DIMENSION_NBT_KEY = "Dimension";

    public static class_3222 makePlayer(GameProfile gameProfile) {
        MinecraftServer server = ServerHelper.getServer();
        class_8791 syncedClientOptions = class_8791.method_53821();
        return new class_3222(server, server.method_30002(), gameProfile, syncedClientOptions);
    }

    private static void applyPlayerData(class_3222 player, @Nullable class_2487 playerData) {
        if (playerData == null) {
            return;
        }
        if (playerData.method_10545(DIMENSION_NBT_KEY)) {
            String dimensionId = NbtHelper.getString(playerData, DIMENSION_NBT_KEY);
            PlayerHelper.setServerWorld(player, dimensionId);
        }
    }

    public static boolean isRealPlayer(@NotNull class_3222 player) {
        return player.getClass() == class_3222.class;
    }

    public static class_3222 loadOfflinePlayer(String playerName) {
        Optional<GameProfile> gameProfile = PlayerHelper.getGameProfileByName(playerName);
        if (gameProfile.isEmpty()) {
            throw new IllegalArgumentException("can't find player %s in usercache.json".formatted(playerName));
        }
        class_3222 player = PlayerHelper.makePlayer(gameProfile.get());
        Optional playerDataOpt = ServerHelper.getPlayerManager().method_14600(player);
        PlayerHelper.applyPlayerData(player, playerDataOpt.orElse(null));
        return player;
    }

    private static Optional<GameProfile> getGameProfileByName(String playerName) {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return Optional.empty();
        }
        return userCache.method_14515(playerName);
    }

    public static void setServerWorld(class_3222 player, String dimensionId) {
        class_3218 world = RegistryHelper.ofServerWorld(dimensionId);
        if (world != null) {
            player.method_51468(world);
        }
    }

    public static void playSound(class_3222 player, class_3414 soundEvent, class_3419 soundCategory, float volume, float pitch) {
        player.method_17356(soundEvent, soundCategory, volume, pitch);
    }

    public static int getPing(class_3222 player) {
        return player.field_13987.method_52405();
    }

    public static String getPropertyValue(Property property) {
        return property.value();
    }

    public static String getName(class_1657 player) {
        return player.method_7334().getName();
    }

    public static boolean isServerPlayer(class_1657 player) {
        return player instanceof class_3222;
    }

    private PlayerHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

