/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.command.argument.adapter.abst;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.command.argument.structure.Argument;
import io.github.sakurawald.core.manager.Managers;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public abstract class BaseArgumentTypeAdapter {
    private static final Map<String, Class<?>> predefined = new HashMap<String, Class<?>>(){
        {
            this.put("str", String.class);
            this.put("int", Integer.TYPE);
        }
    };
    private static final Map<String, Class<?>> string2class = new HashMap<String, Class<?>>(){
        {
            this.putAll(predefined);
        }
    };
    private static final List<BaseArgumentTypeAdapter> adapters = new ArrayList<BaseArgumentTypeAdapter>();

    public static void registerAdapters() {
        string2class.clear();
        ReflectionUtil.getGraph("argument-type-adapter-graph.txt").stream().filter(className -> Managers.getModuleManager().shouldWeEnableThis((String)className)).forEach(className -> {
            try {
                Class<?> clazz = Class.forName(className);
                Constructor<?> constructor = clazz.getDeclaredConstructor(new Class[0]);
                BaseArgumentTypeAdapter adapter = (BaseArgumentTypeAdapter)constructor.newInstance(new Object[0]);
                adapters.add(adapter);
                Class<?> typeClass = adapter.getTypeClasses().get(0);
                adapter.getTypeStrings().forEach(typeString -> {
                    if (string2class.containsKey(typeString) && !predefined.containsKey(typeString)) {
                        throw new IllegalStateException("Type `%s` is already registered".formatted(typeString));
                    }
                    string2class.put((String)typeString, typeClass);
                });
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
    }

    public static Class<?> toTypeClass(String typeString) {
        Class<?> type = string2class.get(typeString);
        if (type == null) {
            throw new IllegalArgumentException("Unknown argument type `%s`".formatted(typeString));
        }
        return type;
    }

    private static Object box(Argument argument, Object value) {
        if (argument.isOptional()) {
            return Optional.of(value);
        }
        return value;
    }

    public static BaseArgumentTypeAdapter getAdapter(Class<?> type) {
        for (BaseArgumentTypeAdapter adapter : adapters) {
            if (!adapter.match(type)) continue;
            return adapter;
        }
        throw new RuntimeException("No adapters match the argument type: " + type.getTypeName());
    }

    private boolean match(Class<?> clazz) {
        return this.getTypeClasses().stream().anyMatch(it -> it.equals(clazz));
    }

    public RequiredArgumentBuilder<class_2168, ?> makeRequiredArgumentBuilder(String argumentName) {
        ArgumentType<?> argumentType = this.makeArgumentType();
        return class_2170.method_9244((String)argumentName, argumentType);
    }

    protected abstract ArgumentType<?> makeArgumentType();

    protected abstract Object makeArgumentObject(CommandContext<class_2168> var1, Argument var2);

    public abstract List<Class<?>> getTypeClasses();

    public abstract List<String> getTypeStrings();

    public final Object makeParameterObject(CommandContext<class_2168> ctx, Argument argument) {
        Object argumentObject = this.makeArgumentObject(ctx, argument);
        return BaseArgumentTypeAdapter.box(argument, argumentObject);
    }

    public boolean verifyCommandSource(CommandContext<class_2168> context) {
        return true;
    }

    public static List<BaseArgumentTypeAdapter> getAdapters() {
        return adapters;
    }
}

