/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.command.structure;

import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class ExtendedCommandSource {
    @NotNull
    private class_2168 initiatingSource;
    @NotNull
    private class_2168 executingSource;
    private boolean parsePlaceholder;

    public static ExtendedCommandSource fromSource(@NotNull class_2168 initiatingSource) {
        return new ExtendedCommandSource(initiatingSource, initiatingSource, true);
    }

    public static ExtendedCommandSource asConsole(@NotNull class_2168 initiatingSource, boolean parsePlaceholder) {
        return new ExtendedCommandSource(initiatingSource, ServerHelper.getServer().method_3739(), parsePlaceholder);
    }

    public static ExtendedCommandSource asPlayer(@NotNull class_2168 initiatingSource, class_3222 executingPlayer, boolean parsePlaceholder) {
        return new ExtendedCommandSource(initiatingSource, executingPlayer.method_64396(), parsePlaceholder);
    }

    public static ExtendedCommandSource asFakeOp(@NotNull class_2168 initiatingSource, class_3222 executingPlayer, boolean parsePlaceholder) {
        return new ExtendedCommandSource(initiatingSource, executingPlayer.method_64396().method_9206(4), parsePlaceholder);
    }

    public static ExtendedCommandSource asConsole(@NotNull class_2168 initiatingSource) {
        return ExtendedCommandSource.asConsole(initiatingSource, true);
    }

    public static ExtendedCommandSource asPlayer(@NotNull class_2168 initiatingSource, class_3222 executingPlayer) {
        return ExtendedCommandSource.asPlayer(initiatingSource, executingPlayer, true);
    }

    public static ExtendedCommandSource asFakeOp(@NotNull class_2168 initiatingSource, class_3222 executingPlayer) {
        return ExtendedCommandSource.asFakeOp(initiatingSource, executingPlayer, true);
    }

    public boolean sameSource() {
        return this.executingSource.method_9214().equals(this.initiatingSource.method_9214());
    }

    private class_2168 getPlaceholderParsingSource() {
        if (this.executingSource.method_43737()) {
            return this.executingSource;
        }
        return this.initiatingSource;
    }

    public String expandCommand(String string) {
        if (!this.parsePlaceholder) {
            return string;
        }
        class_3222 contextualPlayer = this.getPlaceholderParsingSource().method_44023();
        string = contextualPlayer != null ? TextHelper.parsePlaceholder(contextualPlayer, string) : TextHelper.parsePlaceholder(ServerHelper.getServer(), string);
        return string;
    }

    public String toString() {
        return "ExtendedCommandSource{initiatingSource=" + this.initiatingSource.method_9214() + ", executingSource=" + this.executingSource.method_9214() + ", parsePlaceholder=" + this.parsePlaceholder + "}";
    }

    @NotNull
    public class_2168 getInitiatingSource() {
        return this.initiatingSource;
    }

    @NotNull
    public class_2168 getExecutingSource() {
        return this.executingSource;
    }

    public boolean isParsePlaceholder() {
        return this.parsePlaceholder;
    }

    public void setInitiatingSource(@NotNull class_2168 initiatingSource) {
        if (initiatingSource == null) {
            throw new NullPointerException("initiatingSource is marked non-null but is null");
        }
        this.initiatingSource = initiatingSource;
    }

    public void setExecutingSource(@NotNull class_2168 executingSource) {
        if (executingSource == null) {
            throw new NullPointerException("executingSource is marked non-null but is null");
        }
        this.executingSource = executingSource;
    }

    public void setParsePlaceholder(boolean parsePlaceholder) {
        this.parsePlaceholder = parsePlaceholder;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ExtendedCommandSource)) {
            return false;
        }
        ExtendedCommandSource other = (ExtendedCommandSource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isParsePlaceholder() != other.isParsePlaceholder()) {
            return false;
        }
        class_2168 this$initiatingSource = this.getInitiatingSource();
        class_2168 other$initiatingSource = other.getInitiatingSource();
        if (this$initiatingSource == null ? other$initiatingSource != null : !this$initiatingSource.equals(other$initiatingSource)) {
            return false;
        }
        class_2168 this$executingSource = this.getExecutingSource();
        class_2168 other$executingSource = other.getExecutingSource();
        return !(this$executingSource == null ? other$executingSource != null : !this$executingSource.equals(other$executingSource));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ExtendedCommandSource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isParsePlaceholder() ? 79 : 97);
        class_2168 $initiatingSource = this.getInitiatingSource();
        result = result * 59 + ($initiatingSource == null ? 43 : $initiatingSource.hashCode());
        class_2168 $executingSource = this.getExecutingSource();
        result = result * 59 + ($executingSource == null ? 43 : $executingSource.hashCode());
        return result;
    }

    private ExtendedCommandSource(@NotNull class_2168 initiatingSource, @NotNull class_2168 executingSource, boolean parsePlaceholder) {
        if (initiatingSource == null) {
            throw new NullPointerException("initiatingSource is marked non-null but is null");
        }
        if (executingSource == null) {
            throw new NullPointerException("executingSource is marked non-null but is null");
        }
        this.initiatingSource = initiatingSource;
        this.executingSource = executingSource;
        this.parsePlaceholder = parsePlaceholder;
    }
}

