/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.job.impl;

import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.job.abst.FixedIntervalJob;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import org.jetbrains.annotations.NotNull;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class MentionPlayersJob
extends FixedIntervalJob {
    public MentionPlayersJob(JobDataMap jobDataMap, int intervalMs, int repeatCount) {
        super(null, null, jobDataMap, intervalMs, repeatCount);
    }

    public static void submitJob(final MentionPlayer setup, final List<class_3222> players) {
        int intervalMs = setup.interval_ms;
        int repeatCount = setup.repeat_count;
        new MentionPlayersJob(new JobDataMap(){
            {
                this.put(List.class.getName(), players);
                this.put(MentionPlayer.class.getName(), setup);
            }
        }, intervalMs, repeatCount).schedule();
    }

    public static void submitJob(MentionPlayer setup, class_3222 serverPlayer) {
        MentionPlayersJob.submitJob(setup, new ArrayList<class_3222>(Collections.singletonList(serverPlayer)));
    }

    public void execute(@NotNull JobExecutionContext context) {
        List players = (List)context.getJobDetail().getJobDataMap().get((Object)List.class.getName());
        MentionPlayer setup = (MentionPlayer)context.getJobDetail().getJobDataMap().get((Object)MentionPlayer.class.getName());
        for (class_3222 player : players) {
            if (player == null) continue;
            ServerHelper.getServer().method_40000(() -> {
                class_3414 soundEvent = class_3414.method_47908((class_2960)RegistryHelper.makeIdentifier(setup.sound));
                class_3419 soundCategory = class_3419.field_15245;
                PlayerHelper.playSound(player, soundEvent, soundCategory, setup.volume, setup.pitch);
            });
        }
    }

    public MentionPlayersJob() {
    }

    public static class MentionPlayer {
        @NotNull
        public String sound = "entity.experience_orb.pickup";
        public float volume = 100.0f;
        public float pitch = 1.0f;
        public int repeat_count = 3;
        public int interval_ms = 1000;
    }
}

