/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.callback.structure;

import io.github.sakurawald.core.job.abst.CronJob;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;

public class TTLMap<K, V> {
    private final ConcurrentMap<K, ExpiringValue<V>> map = new ConcurrentHashMap<K, ExpiringValue<V>>();

    public TTLMap() {
        new CleanTTLMapJob(new JobDataMap(){
            {
                this.put(TTLMap.class.getName(), TTLMap.this);
            }
        }, () -> "0 * * ? * * *").schedule();
    }

    public void put(K key, V value, long ttl, TimeUnit unit) {
        long expiryTime = System.currentTimeMillis() + unit.toMillis(ttl);
        this.map.put(key, new ExpiringValue<V>(value, expiryTime));
    }

    public V get(K key) {
        ExpiringValue expiringValue = (ExpiringValue)this.map.get(key);
        if (expiringValue != null && System.currentTimeMillis() < expiringValue.expiryTime) {
            return expiringValue.value;
        }
        this.map.remove(key);
        return null;
    }

    public void remove(K key) {
        this.map.remove(key);
    }

    private void cleanUp() {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry entry : this.map.entrySet()) {
            if (currentTime <= ((ExpiringValue)entry.getValue()).expiryTime) continue;
            this.map.remove(entry.getKey());
        }
    }

    public static class CleanTTLMapJob
    extends CronJob {
        public CleanTTLMapJob(JobDataMap jobDataMap, Supplier<String> cronSupplier) {
            super(jobDataMap, cronSupplier);
        }

        public void execute(JobExecutionContext context) {
            TTLMap instance = (TTLMap)context.getJobDetail().getJobDataMap().get((Object)TTLMap.class.getName());
            instance.cleanUp();
        }

        public CleanTTLMapJob() {
        }
    }

    private record ExpiringValue<V>(V value, long expiryTime) {
    }
}

