/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.service.random_teleport;

import com.google.common.base.Stopwatch;
import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.auxiliary.minecraft.WorldHelper;
import io.github.sakurawald.core.service.random_teleport.structure.HeightFindingStrategy;
import io.github.sakurawald.core.structure.GlobalPos;
import io.github.sakurawald.core.structure.TeleportSetup;
import java.util.Iterator;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Random;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Cite(value={"https://github.com/John-Paul-R/Essential-Commands"})
public final class RandomTeleporter {
    public static void request(@NotNull class_3222 player, @NotNull TeleportSetup setup, @Nullable Consumer<GlobalPos> postConsumer) {
        CompletableFuture.runAsync(() -> {
            Optional<class_2338> result;
            LogUtil.info("Request rtp: {}", player.method_7334().getName());
            Stopwatch timer = Stopwatch.createStarted();
            class_3218 world = RegistryHelper.ofServerWorld(setup.getDimension());
            if (world == null) {
                LogUtil.debug("Abort rtp for {} (target dimension not found in server)", player);
                TextHelper.sendMessageByKey(player, "world.dimension.not_found", new Object[0]);
                return;
            }
            int triedTimes = 0;
            while ((result = RandomTeleporter.searchPosition(setup)).isEmpty() && ++triedTimes <= setup.getMaxTryTimes()) {
            }
            if (result.isEmpty()) {
                LogUtil.debug("Abort rtp for {} (run out max tried times)", player);
                TextHelper.sendMessageByKey(player, "rtp.fail", new Object[0]);
                return;
            }
            GlobalPos globalPos = new GlobalPos((class_1937)world, (double)result.get().method_10263() + 0.5, (double)result.get().method_10264(), (double)result.get().method_10260() + 0.5, 0.0f, 0.0f);
            ServerHelper.getServer().method_40000(() -> globalPos.teleport(player));
            if (postConsumer != null) {
                postConsumer.accept(globalPos);
            }
            Stopwatch cost = timer.stop();
            LogUtil.info("Response rtp: {} has been teleported to ({} {} {} {}) (cost = {})", player.method_7334().getName(), world.method_27983().method_29177(), result.get().method_10263(), result.get().method_10264(), result.get().method_10260(), cost);
        });
    }

    @NotNull
    private static Optional<class_2338> searchPosition(@NotNull TeleportSetup setup) {
        class_2338 targetXZ = RandomTeleporter.getRandomXZ(setup);
        class_3218 serverWorld = setup.ofWorld();
        class_2791 chunk = serverWorld.method_22350(targetXZ);
        for (class_2338.class_2339 candidateBlock : RandomTeleporter.getChunkCandidateBlocks(chunk.method_12004())) {
            int y;
            int x = candidateBlock.method_10263();
            int z = candidateBlock.method_10260();
            HeightFindingStrategy heightFinder = HeightFindingStrategy.forWorld(setup.ofWorld());
            OptionalInt yOpt = heightFinder.getY(chunk, x, z);
            if (yOpt.isEmpty() || !RandomTeleporter.isSatisfied(setup, chunk, new class_2338(x, (y = yOpt.getAsInt()) - 2, z))) continue;
            return Optional.of(new class_2338(x, y, z));
        }
        return Optional.empty();
    }

    @NotNull
    private static class_2338 getRandomXZ(@NotNull TeleportSetup setup) {
        return setup.isCircle() ? RandomTeleporter.getRandomXZWithCircle(setup) : RandomTeleporter.getRandomXZWithRect(setup);
    }

    @NotNull
    private static class_2338 getRandomXZWithCircle(@NotNull TeleportSetup setup) {
        Random rand = new Random();
        int r_min = setup.getMinRange();
        int r_max = setup.getMaxRange();
        int r = r_max == r_min ? r_max : rand.nextInt(r_min, r_max);
        double angle = rand.nextDouble() * 2.0 * Math.PI;
        double delta_x = (double)r * Math.cos(angle);
        double delta_z = (double)r * Math.sin(angle);
        int x = setup.getCenterX() + (int)delta_x;
        int z = setup.getCenterZ() + (int)delta_z;
        return new class_2338(x, 0, z);
    }

    @NotNull
    private static class_2338 getRandomXZWithRect(@NotNull TeleportSetup setup) {
        Random rand = new Random();
        int r_min = setup.getMinRange();
        int r_max = setup.getMaxRange();
        int x = setup.getCenterX() + rand.nextInt(r_min, r_max);
        int z = setup.getCenterZ() + rand.nextInt(r_min, r_max);
        return new class_2338(x, 0, z);
    }

    private static boolean isSatisfied(@NotNull TeleportSetup setup, @NotNull class_2791 chunk, @NotNull class_2338 pos) {
        class_2680 blockState = chunk.method_8320(pos);
        return pos.method_10264() >= setup.getMinY() && pos.method_10264() <= setup.getMaxY() && blockState.method_26227().method_15769() && blockState.method_26204() != class_2246.field_27879 && blockState.method_26204() != class_2246.field_10036 && pos.method_10264() >= chunk.method_31607() && pos.method_10264() <= WorldHelper.getTopY(chunk);
    }

    @NotNull
    private static Iterable<class_2338.class_2339> getChunkCandidateBlocks(final @NotNull class_1923 chunkPos) {
        return () -> new Iterator<class_2338.class_2339>(){
            private final class_2338.class_2339 bp = new class_2338.class_2339();
            private int i = -1;

            @Override
            public boolean hasNext() {
                return this.i < 4;
            }

            @Override
            public class_2338.class_2339 next() {
                ++this.i;
                return switch (this.i) {
                    case 0 -> this.bp.method_10103(chunkPos.method_8326(), 0, chunkPos.method_8328());
                    case 1 -> this.bp.method_10103(chunkPos.method_8326(), 0, chunkPos.method_8329());
                    case 2 -> this.bp.method_10103(chunkPos.method_8327(), 0, chunkPos.method_8328());
                    case 3 -> this.bp.method_10103(chunkPos.method_8327(), 0, chunkPos.method_8329());
                    case 4 -> this.bp.method_10103(chunkPos.method_33940(), 0, chunkPos.method_33942());
                    default -> throw new IllegalStateException("Unexpected value: " + this.i);
                };
            }
        };
    }

    private RandomTeleporter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

