/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.back.structure;

import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.structure.GlobalPos;
import java.util.Comparator;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class LocationEntry
implements Comparable<LocationEntry> {
    private GlobalPos location;
    private Long savedTimestamp;

    public static LocationEntry makeLocationEntry(@NotNull class_3222 player) {
        GlobalPos location = GlobalPos.of(player);
        Long saved_timestamp = ChronosUtil.getCurrentMillis();
        return new LocationEntry(location, saved_timestamp);
    }

    @Override
    public int compareTo(@NotNull LocationEntry that) {
        return Comparator.comparingLong(LocationEntry::getSavedTimestamp).compare(this, that);
    }

    public GlobalPos getLocation() {
        return this.location;
    }

    public Long getSavedTimestamp() {
        return this.savedTimestamp;
    }

    public void setLocation(GlobalPos location) {
        this.location = location;
    }

    public void setSavedTimestamp(Long savedTimestamp) {
        this.savedTimestamp = savedTimestamp;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LocationEntry)) {
            return false;
        }
        LocationEntry other = (LocationEntry)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$savedTimestamp = this.getSavedTimestamp();
        Long other$savedTimestamp = other.getSavedTimestamp();
        if (this$savedTimestamp == null ? other$savedTimestamp != null : !((Object)this$savedTimestamp).equals(other$savedTimestamp)) {
            return false;
        }
        GlobalPos this$location = this.getLocation();
        GlobalPos other$location = other.getLocation();
        return !(this$location == null ? other$location != null : !((Object)this$location).equals(other$location));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LocationEntry;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $savedTimestamp = this.getSavedTimestamp();
        result = result * 59 + ($savedTimestamp == null ? 43 : ((Object)$savedTimestamp).hashCode());
        GlobalPos $location = this.getLocation();
        result = result * 59 + ($location == null ? 43 : ((Object)$location).hashCode());
        return result;
    }

    public String toString() {
        return "LocationEntry(location=" + String.valueOf(this.getLocation()) + ", savedTimestamp=" + this.getSavedTimestamp() + ")";
    }

    public LocationEntry(GlobalPos location, Long savedTimestamp) {
        this.location = location;
        this.savedTimestamp = savedTimestamp;
    }
}

