/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_toolbox.warp;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.annotation.CommandTarget;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.core.command.executor.CommandExecutor;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.service.string_splitter.StringSplitter;
import io.github.sakurawald.core.structure.GlobalPos;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_toolbox.warp.command.argument.wrapper.WarpName;
import io.github.sakurawald.module.initializer.command_toolbox.warp.config.model.WarpDataModel;
import io.github.sakurawald.module.initializer.command_toolbox.warp.gui.WarpGui;
import io.github.sakurawald.module.initializer.command_toolbox.warp.structure.WarpNode;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

@CommandNode(value="warp")
public class WarpInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<WarpDataModel> data = new ObjectConfigurationHandler<WarpDataModel>("warp.json", WarpDataModel.class).autoSaveEveryMinute();

    private static void ensureWarpExists(class_3222 player, WarpName warpName) {
        String name = (String)warpName.getValue();
        if (!WarpInitializer.data.model().name2warp.containsKey(name)) {
            TextHelper.sendMessageByKey(player, "warp.not_found", name);
            throw new AbortCommandExecutionException();
        }
    }

    private static int withWarpNode(class_3222 player, WarpName warpName, Function<WarpNode, Integer> consumer) {
        WarpInitializer.ensureWarpExists(player, warpName);
        String name = (String)warpName.getValue();
        WarpNode entry = WarpInitializer.data.model().name2warp.get(name);
        return consumer.apply(entry);
    }

    public static void doWarp(WarpNode warpNode, class_3222 player) {
        warpNode.getPosition().teleport(player);
        CommandExecutor.execute(ExtendedCommandSource.asConsole(player.method_64396()), warpNode.getEvent().on_warped.command_list);
        TextHelper.sendMessageByKey(player, "warp.tp.success", warpNode.name);
    }

    @CommandNode(value="tp")
    private static int $tp(@CommandSource @CommandTarget class_3222 player, WarpName warpName) {
        return WarpInitializer.withWarpNode(player, warpName, warpNode -> {
            WarpInitializer.doWarp(warpNode, player);
            return 1;
        });
    }

    @CommandNode(value="unset")
    @CommandRequirement(level=4)
    private static int $unset(@CommandSource class_3222 player, WarpName warpName) {
        WarpInitializer.ensureWarpExists(player, warpName);
        String name = (String)warpName.getValue();
        WarpInitializer.data.model().name2warp.remove(name);
        TextHelper.sendMessageByKey(player, "warp.unset.success", name);
        return 1;
    }

    @CommandNode(value="set")
    @CommandRequirement(level=4)
    private static int $set(@CommandSource class_3222 player, WarpName warpName, Optional<Boolean> override) {
        String name = (String)warpName.getValue();
        if (WarpInitializer.data.model().name2warp.containsKey(name) && !override.orElse(false).booleanValue()) {
            TextHelper.sendMessageByKey(player, "warp.set.fail.need_override", name);
            return -1;
        }
        WarpNode value = new WarpNode(GlobalPos.of(player)).withName(name);
        WarpInitializer.data.model().name2warp.put(name, value);
        TextHelper.sendMessageByKey(player, "warp.set.success", name);
        return 1;
    }

    @CommandNode
    private static int $root(@CommandSource class_2168 source) {
        return WarpInitializer.$list(source);
    }

    @CommandNode(value="list")
    private static int $list(@CommandSource class_2168 source) {
        if (source.method_43737()) {
            List<WarpNode> list = WarpInitializer.data.model().name2warp.values().stream().toList();
            new WarpGui(source.method_44023(), list, 0).open();
        } else {
            TextHelper.sendMessageByKey(source, "warp.list", WarpInitializer.data.model().name2warp.keySet());
        }
        return 1;
    }

    @CommandNode(value="set-name")
    @CommandRequirement(level=4)
    @Document(value="Set the display name for a warp.")
    private static int $setName(@CommandSource class_3222 player, WarpName warp, GreedyString name) {
        return WarpInitializer.withWarpNode(player, warp, warpNode -> {
            warpNode.setName((String)name.getValue());
            return 1;
        });
    }

    @CommandNode(value="set-item")
    @CommandRequirement(level=4)
    @Document(value="Set the item for a warp.")
    private static int $setItem(@CommandSource class_3222 player, WarpName warp, class_1792 item) {
        return WarpInitializer.withWarpNode(player, warp, warpNode -> {
            warpNode.setItem(RegistryHelper.ofString(item));
            return 1;
        });
    }

    @CommandNode(value="set-lore")
    @CommandRequirement(level=4)
    @Document(value="Set the lore for a warp.")
    private static int $setLore(@CommandSource class_3222 player, WarpName warp, GreedyString lore) {
        return WarpInitializer.withWarpNode(player, warp, warpNode -> {
            List<String> split = StringSplitter.split((String)lore.getValue());
            warpNode.setLore(split);
            return 1;
        });
    }
}

