/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.deathlog;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.InventoryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.NbtHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.OfflinePlayerName;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_4844;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;

@CommandNode(value="deathlog")
@CommandRequirement(level=4)
public class DeathLogInitializer
extends ModuleInitializer {
    private static final Path DEATH_DATA_DIR_PATH = ReflectionUtil.computeModuleConfigPath(DeathLogInitializer.class).resolve("death-data");
    private static final String DEATHS = "Deaths";
    private static final String TIME = "time";
    private static final String REASON = "reason";
    private static final String DIMENSION = "dimension";
    private static final String X = "x";
    private static final String Y = "y";
    private static final String Z = "z";
    private static final String REMARK = "remark";
    private static final String ARMOR = "armor";
    private static final String OFFHAND = "offhand";
    private static final String ITEM = "item";
    private static final String SCORE = "score";
    private static final String XP_LEVEL = "xp_level";
    private static final String XP_PROGRESS = "xp_progress";
    private static final String INVENTORY = "inventory";

    @CommandNode(value="restore")
    @Document(value="Restore a deathlog.")
    private static int restore(@CommandSource class_2168 source, @Document(value="Where the deathlog from?") String from, @Document(value="The index to select a deathlog.") int index, @Document(value="Where the deathlog is restored to?") class_3222 to) {
        NbtHelper.withNbtFile(DeathLogInitializer.computePath(from), root -> {
            DeathLogInitializer.ensureDeathlogNotEmpty(source, root);
            class_2499 deathListNode = NbtHelper.withNbtElement(root, DEATHS, new class_2499());
            if (index >= deathListNode.size()) {
                TextHelper.sendMessageByKey(source, "deathlog.index.not_found", index);
                throw new AbortCommandExecutionException();
            }
            if (!to.method_31548().method_5442()) {
                TextHelper.sendMessageByKey(source, "deathlog.restore.target_player.inventory_not_empty", to.method_7334().getName());
                throw new AbortCommandExecutionException();
            }
            class_2487 deathNode = NbtHelper.getCompound(deathListNode, index);
            class_2487 inventoryNode = NbtHelper.getCompound(deathNode, INVENTORY);
            List<class_1799> item = NbtHelper.readSlotsNode((class_2499)inventoryNode.method_10580(ITEM));
            for (int i = 0; i < item.size(); ++i) {
                InventoryHelper.getMainStacks((class_1657)to).set(i, (Object)item.get(i));
            }
            List<class_1799> armor = NbtHelper.readSlotsNode((class_2499)inventoryNode.method_10580(ARMOR));
            InventoryHelper.setArmorStacks((class_1657)to, armor);
            List<class_1799> offhand = NbtHelper.readSlotsNode((class_2499)inventoryNode.method_10580(OFFHAND));
            InventoryHelper.setOffhandStacks((class_1657)to, offhand);
            to.method_7320(NbtHelper.getInt(inventoryNode, SCORE));
            to.field_7520 = NbtHelper.getInt(inventoryNode, XP_LEVEL);
            to.field_7510 = NbtHelper.getFloat(inventoryNode, XP_PROGRESS);
            TextHelper.sendMessageByKey(source, "deathlog.restore.success", from, index, to.method_7334().getName());
        });
        return 1;
    }

    @NotNull
    private static Path computePath(String playerName) {
        String fileName = String.valueOf(class_4844.method_43344((String)playerName)) + ".dat";
        return DEATH_DATA_DIR_PATH.resolve(fileName);
    }

    private static void ensureDeathlogNotEmpty(class_2168 source, class_2487 root) {
        if (root == null || root.method_33133()) {
            TextHelper.sendMessageByKey(source, "deathlog.empty", new Object[0]);
            throw new AbortCommandExecutionException();
        }
    }

    @CommandNode(value="view")
    @Document(value="List all deathlog of a player.")
    private static int view(@CommandSource class_3222 player, OfflinePlayerName from) {
        String $from = (String)from.getValue();
        NbtHelper.withNbtFile(DeathLogInitializer.computePath($from), root -> {
            DeathLogInitializer.ensureDeathlogNotEmpty(player.method_64396(), root);
            class_2499 deaths = NbtHelper.withNbtElement(root, DEATHS, new class_2499());
            class_5250 deathlogViewText = class_2561.method_43473();
            String to = player.method_7334().getName();
            for (int i = 0; i < deaths.size(); ++i) {
                deathlogViewText.method_10852(DeathLogInitializer.asViewText(player, NbtHelper.getCompound(deaths, i), $from, i, to));
            }
            player.method_64398((class_2561)deathlogViewText);
        });
        return 1;
    }

    @NotNull
    private static class_2561 asViewText(Object audience, @NotNull class_2487 node, String from, int index, String to) {
        class_2487 remarkTag = NbtHelper.getCompound(node, REMARK);
        class_5250 hoverText = class_2561.method_43473().method_10852(TextHelper.getTextByKey(audience, "deathlog.view.time", NbtHelper.getString(remarkTag, TIME))).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(audience, "deathlog.view.reason", NbtHelper.getString(remarkTag, REASON))).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(audience, "deathlog.view.dimension", NbtHelper.getString(remarkTag, DIMENSION))).method_10852(TextHelper.TEXT_NEWLINE).method_10852(TextHelper.getTextByKey(audience, "deathlog.view.coordinate", NbtHelper.getDouble(remarkTag, X), NbtHelper.getDouble(remarkTag, Y), NbtHelper.getDouble(remarkTag, Z)));
        return class_2561.method_43470((String)String.valueOf(index)).method_27696(class_2583.field_24360.method_27706(class_124.field_1061).method_10949(TextHelper.HoverEvent.makeShowTextAction((class_2561)hoverText)).method_10958(TextHelper.ClickEvent.makeRunCommandAction("/deathlog restore %s %d %s".formatted(from, index, to)))).method_10852(TextHelper.TEXT_SPACE);
    }

    public static void store(@NotNull class_3222 player) {
        if (player.method_31548().method_5442()) {
            return;
        }
        NbtHelper.withNbtFile(DeathLogInitializer.computePath(player.method_7334().getName()), root -> {
            class_2499 deathsNode = NbtHelper.withNbtElement(root, DEATHS, new class_2499());
            deathsNode.add((Object)DeathLogInitializer.makeDeathNode(player));
        });
    }

    @NotNull
    private static class_2487 makeDeathNode(@NotNull class_3222 player) {
        class_2487 node = new class_2487();
        DeathLogInitializer.writeInventoryNode(node, player);
        DeathLogInitializer.writeRemarkNode(node, player);
        return node;
    }

    private static void writeRemarkNode(@NotNull class_2487 node, @NotNull class_3222 player) {
        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        String reason = player.method_6066().method_5548().getString();
        String dimension = player.method_37908().method_27983().method_29177().toString();
        class_243 position = player.method_19538();
        class_2487 remarkTag = new class_2487();
        remarkTag.method_10582(TIME, time);
        remarkTag.method_10582(REASON, reason);
        remarkTag.method_10582(DIMENSION, dimension);
        remarkTag.method_10549(X, position.field_1352);
        remarkTag.method_10549(Y, position.field_1351);
        remarkTag.method_10549(Z, position.field_1350);
        node.method_10566(REMARK, (class_2520)remarkTag);
    }

    private static void writeInventoryNode(@NotNull class_2487 node, @NotNull class_3222 player) {
        class_2487 inventoryTag = new class_2487();
        class_1661 inventory = player.method_31548();
        LogUtil.debug("Write armor slots for {}", player);
        inventoryTag.method_10566(ARMOR, (class_2520)NbtHelper.writeSlotsNode(new class_2499(), InventoryHelper.getArmorStacks((class_1657)player)));
        LogUtil.debug("Write off-hand slots for {}", player);
        inventoryTag.method_10566(OFFHAND, (class_2520)NbtHelper.writeSlotsNode(new class_2499(), InventoryHelper.getOffhandStack((class_1657)player)));
        LogUtil.debug("Write main stacks slots for {}", player);
        inventoryTag.method_10566(ITEM, (class_2520)NbtHelper.writeSlotsNode(new class_2499(), InventoryHelper.getMainStacks((class_1657)player)));
        inventoryTag.method_10569(SCORE, player.method_7272());
        inventoryTag.method_10569(XP_LEVEL, player.field_7520);
        inventoryTag.method_10548(XP_PROGRESS, player.field_7510);
        node.method_10566(INVENTORY, (class_2520)inventoryTag);
    }

    @Override
    protected void onInitialize() {
        Files.createDirectories(DEATH_DATA_DIR_PATH, new FileAttribute[0]);
    }
}

