/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.motd;

import com.google.common.base.Preconditions;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.RandomUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.motd.config.model.MotdConfigModel;
import io.github.sakurawald.module.initializer.motd.structure.MotdEntry;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import javax.imageio.ImageIO;
import net.minecraft.class_2926;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotdInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<MotdConfigModel> config = new ObjectConfigurationHandler<MotdConfigModel>("config.json", MotdConfigModel.class);
    private static final Path ICON_FOLDER = ReflectionUtil.computeModuleConfigPath(MotdInitializer.class).resolve("icon");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    public static Optional<class_2926.class_8145> getMotdIcon(@Nullable String preferIcon) {
        try {
            Files.createDirectories(ICON_FOLDER, new FileAttribute[0]);
            Stream<Path> temp = Files.list(ICON_FOLDER);
            try {
                File chooseItem;
                List<File> availableIcons = temp.map(Path::toFile).toList();
                if (preferIcon == null) {
                    if (availableIcons.isEmpty()) {
                        Optional<class_2926.class_8145> optional = Optional.empty();
                        return optional;
                    }
                    chooseItem = RandomUtil.drawList(availableIcons);
                } else {
                    chooseItem = ICON_FOLDER.resolve(preferIcon).toFile();
                }
                BufferedImage bufferedImage = ImageIO.read(chooseItem);
                Preconditions.checkState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide: %s".formatted(chooseItem));
                Preconditions.checkState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high: %s".formatted(chooseItem));
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)bufferedImage, "PNG", byteArrayOutputStream);
                return Optional.of(new class_2926.class_8145(byteArrayOutputStream.toByteArray()));
            }
            finally {
                if (Collections.singletonList(temp).get(0) != null) {
                    temp.close();
                }
            }
        }
        catch (Exception e) {
            LogUtil.error("Failed to read icon %s.".formatted(preferIcon), e);
            return Optional.empty();
        }
    }

    @NotNull
    public static MotdEntry getMotdEntry() {
        return RandomUtil.drawList(MotdInitializer.config.model().entries);
    }
}

