/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.predicate;

import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.core.auxiliary.minecraft.EntityHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.Dimension;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1934;
import net.minecraft.class_2168;
import net.minecraft.class_2293;
import net.minecraft.class_3222;

@CommandRequirement(level=4)
public class PredicateInitializer
extends ModuleInitializer {
    @CommandNode(value="has-perm?")
    @Document(value="Predicate to test if the player has the string-perm?")
    private static int hasPerm(@CommandSource class_2168 source, class_3222 player, GreedyString stringPermission) {
        boolean value = PermissionHelper.hasPermission(player.method_5667(), (String)stringPermission.getValue());
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="has-level?")
    @Document(value="Predicate to test if the player has the level-perm?")
    private static int hasLevel(@CommandSource class_2168 source, class_3222 player, int levelPermission) {
        boolean value = player.method_64475(levelPermission);
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="has-players?")
    @Document(value="Predicate if online players >= n.")
    private static int hasPlayers(@CommandSource class_2168 source, Optional<Integer> n) {
        int $n = n.orElse(0);
        boolean value = ServerHelper.getPlayers().size() >= $n;
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="is-op?")
    private static int isOp(@CommandSource class_2168 source, class_3222 player) {
        boolean value = ServerHelper.getPlayerManager().method_14569(player.method_7334());
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="is-holding?")
    private static int isHolding(@CommandSource class_2168 source, class_3222 player, class_2293.class_2295 itemPredicate) {
        boolean value = player.method_24520((Predicate)itemPredicate);
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="has-exp?")
    private static int hasExp(@CommandSource class_2168 source, class_3222 player, int exp) {
        boolean value = player.field_7495 >= exp;
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="has-exp-level?")
    private static int hasExpLevel(@CommandSource class_2168 source, class_3222 player, int expLevel) {
        boolean value = player.field_7520 >= expLevel;
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="is-in-world?")
    private static int isInWorld(@CommandSource class_2168 source, class_3222 player, Dimension dimension) {
        boolean value = EntityHelper.getServerWorld((class_1297)player).equals(dimension.getValue());
        return CommandHelper.Return.outputBoolean(source, value);
    }

    @CommandNode(value="is-in-gamemode?")
    private static int isInGameMode(@CommandSource class_2168 source, class_3222 player, class_1934 gameMode) {
        boolean value = player.field_13974.method_14257().equals((Object)gameMode);
        return CommandHelper.Return.outputBoolean(source, value);
    }
}

