/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.skin.structure;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.RandomUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.module.initializer.skin.SkinInitializer;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;

public class SkinStorage {
    private final Path rootPath = ReflectionUtil.computeModuleConfigPath(SkinInitializer.class).resolve("skin-data");
    private final Map<UUID, Property> uuid2skin = new HashMap<UUID, Property>();

    private Path computeFilePath(UUID uuid) {
        return this.rootPath.resolve(String.valueOf(uuid) + ".json");
    }

    public Property getDefaultSkin() {
        return RandomUtil.drawList(SkinInitializer.config.model().default_skins);
    }

    public boolean isDefaultSkin(GameProfile gameProfile) {
        Property textures = gameProfile.getProperties().get((Object)"textures").stream().findFirst().orElse(null);
        if (textures == null) {
            return false;
        }
        return SkinInitializer.config.model().default_skins.stream().anyMatch(it -> PlayerHelper.getPropertyValue(it).equals(PlayerHelper.getPropertyValue(textures)));
    }

    public Property getSkin(UUID uuid) {
        if (!this.uuid2skin.containsKey(uuid)) {
            Property skin = this.readSkin(uuid);
            this.setSkin(uuid, skin);
        }
        return this.uuid2skin.get(uuid);
    }

    public void setSkin(UUID uuid, @Nullable Property skin) {
        if (skin == null) {
            skin = this.getDefaultSkin();
        }
        this.uuid2skin.put(uuid, skin);
    }

    public void writeSkin(UUID uuid) {
        if (this.uuid2skin.containsKey(uuid)) {
            Property skin = this.uuid2skin.get(uuid);
            try {
                File file = this.computeFilePath(uuid).toFile();
                FileUtils.writeStringToFile((File)file, (String)BaseConfigurationHandler.getGson().toJson((Object)skin), (Charset)StandardCharsets.UTF_8);
            }
            catch (IOException e) {
                LogUtil.error("Save skin failed: " + e.getMessage(), new Object[0]);
            }
        }
    }

    @Nullable
    private Property readSkin(UUID uuid) {
        Path playerData = this.computeFilePath(uuid);
        if (Files.notExists(playerData, new LinkOption[0])) {
            return null;
        }
        try {
            String string = Files.readString(playerData);
            return (Property)BaseConfigurationHandler.getGson().fromJson(string, Property.class);
        }
        catch (IOException e) {
            LogUtil.error("Load skin failed: " + e.getMessage(), new Object[0]);
            return null;
        }
    }
}

