/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.works.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.PagedGui;
import io.github.sakurawald.core.structure.GlobalPos;
import io.github.sakurawald.module.initializer.works.WorksInitializer;
import io.github.sakurawald.module.initializer.works.gui.AddWorkGui;
import io.github.sakurawald.module.initializer.works.structure.work.abst.Work;
import io.github.sakurawald.module.initializer.works.structure.work.impl.ProductionWork;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WorksGui
extends PagedGui<Work> {
    public WorksGui(class_3222 player, @NotNull List<Work> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "works.list.title", new Object[0]), entities, pageIndex);
        this.getFooter().setSlot(3, GuiHelper.makeAddButton(player).setName(TextHelper.getTextByKey(player, "works.list.add", new Object[0])).setCallback(() -> new AddWorkGui(player).open()));
        this.getFooter().setSlot(4, (GuiElementBuilderInterface)GuiHelper.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "works.list.help.lore")));
        if (entities == WorksInitializer.works.model().works) {
            this.getFooter().setSlot(5, GuiHelper.makeLetterAButton(player).setName(TextHelper.getTextByKey(player, "works.list.my_works", new Object[0])).setCallback(() -> this.search(player.method_7334().getName()).open()));
        } else {
            this.getFooter().setSlot(5, GuiHelper.makeHeartButton(player).setName(TextHelper.getTextByKey(player, "works.list.all_works", new Object[0])).setCallback(() -> new WorksGui(player, WorksInitializer.works.model().works, 0).open()));
        }
    }

    private boolean hasPermission(@NotNull class_3222 player, @NotNull Work work) {
        return player.method_7334().getName().equals(work.creator) || player.method_64475(4);
    }

    @Override
    protected PagedGui<Work> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Work> entities, int pageIndex) {
        return new WorksGui(player, entities, pageIndex);
    }

    @Override
    protected GuiElementInterface toGuiElement(@NotNull Work entity) {
        class_3222 player = this.getPlayer();
        return new GuiElementBuilder().setItem(entity.getIconItem()).setName(TextHelper.getTextByValue(null, entity.name, new Object[0])).setLore(entity.asLore(player)).setCallback((index, clickType, actionType) -> {
            if (clickType.isLeft) {
                class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)RegistryHelper.makeIdentifier(entity.level));
                class_3218 level = ServerHelper.getServer().method_3847(worldKey);
                if (level != null) {
                    new GlobalPos((class_1937)level, entity.x, entity.y, entity.z, entity.yaw, entity.pitch).teleport(player);
                } else {
                    TextHelper.sendMessageByKey(player, "world.dimension.not_found", entity.level);
                }
                this.close();
                return;
            }
            if (clickType.isRight && clickType.shift) {
                if (!this.hasPermission(player, entity)) {
                    TextHelper.sendActionBarByKey(player, "works.work.set.no_perm", new Object[0]);
                    return;
                }
                entity.openSpecializedSettingsGui(player, (SimpleGui)this.gui);
                this.close();
                return;
            }
            if (clickType.isRight) {
                if (!this.hasPermission(player, entity)) {
                    TextHelper.sendActionBarByKey(player, "works.work.set.no_perm", new Object[0]);
                    return;
                }
                entity.openGeneralSettingsGui(player, (SimpleGui)this.gui);
                this.close();
            }
        }).build();
    }

    @Override
    @NotNull
    protected List<Work> filter(@NotNull String keyword) {
        return this.getEntities().stream().filter((? super T w) -> {
            if (w.creator.contains(keyword)) return true;
            if (w.name.contains(keyword)) return true;
            if (w.introduction != null) {
                if (w.introduction.contains(keyword)) return true;
            }
            if (w.level.contains(keyword)) return true;
            if (w.getIconItemIdentifier().contains(keyword)) return true;
            if (!(w instanceof ProductionWork)) return false;
            ProductionWork pw = (ProductionWork)w;
            if (pw.sample.sampleCounter == null) return false;
            if (!pw.sample.sampleCounter.keySet().stream().anyMatch(k -> k.contains(keyword))) return false;
            return true;
        }).toList();
    }
}

