/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.skin;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.service.gameprofile_fetcher.MojangProfileFetcher;
import io.github.sakurawald.module.initializer.skin.structure.SkinRestorer;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_3248;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3248.class})
public abstract class ServerLoginNetworkHandlerMixin {
    @Shadow
    private GameProfile field_45029;
    @Unique
    private CompletableFuture<Property> pendingSkins;

    @Inject(method={"tickVerify"}, at={@At(value="INVOKE", target="Lnet/minecraft/server/PlayerManager;checkCanJoin(Ljava/net/SocketAddress;Lcom/mojang/authlib/GameProfile;)Lnet/minecraft/text/Text;")}, cancellable=true)
    public void waitForSkin(@NotNull CallbackInfo ci) {
        if (this.pendingSkins == null) {
            this.pendingSkins = CompletableFuture.supplyAsync(() -> {
                LogUtil.info("Fetch skin for {}", this.field_45029.getName());
                if (SkinRestorer.getSkinStorage().isDefaultSkin(this.field_45029)) {
                    SkinRestorer.getSkinStorage().setSkin(this.field_45029.getId(), MojangProfileFetcher.fetchOnlineSkin(this.field_45029.getName()));
                }
                return SkinRestorer.getSkinStorage().getSkin(this.field_45029.getId());
            });
        }
        if (!this.pendingSkins.isDone()) {
            ci.cancel();
        }
    }

    @Inject(method={"sendSuccessPacket"}, at={@At(value="HEAD")})
    public void applyTheFetchedSkin(@NotNull GameProfile gameProfile, CallbackInfo ci) {
        if (this.pendingSkins != null) {
            SkinRestorer.applySkin(gameProfile, this.pendingSkins.getNow(SkinRestorer.getSkinStorage().getDefaultSkin()));
        }
    }
}

