/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.mixin.teleport_warmup;

import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PlayerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.manager.Managers;
import io.github.sakurawald.core.structure.GlobalPos;
import io.github.sakurawald.core.structure.TeleportTicket;
import io.github.sakurawald.module.initializer.teleport_warmup.TeleportWarmupInitializer;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3222.class}, priority=500)
public abstract class ServerPlayerMixin {
    @Inject(method={"teleport"}, at={@At(value="HEAD")}, cancellable=true)
    public void interceptTeleportAndAddTicket(class_3218 serverWorld, double x, double y, double z, Set<class_2709> set, float yaw, float pitch, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        if (!TeleportWarmupInitializer.config.model().dimension.effective_dimensions.contains(RegistryHelper.ofString((class_1937)serverWorld))) {
            return;
        }
        class_3222 player = (class_3222)this;
        if (!PlayerHelper.isRealPlayer(player)) {
            return;
        }
        if (PermissionHelper.hasPermission(player.method_5667(), "fuji.teleport_warmup.bypass")) {
            return;
        }
        TeleportTicket ticket = TeleportWarmupInitializer.getTeleportTicket(player);
        if (ticket == null) {
            Optional<Integer> permission_warmup_time = PermissionHelper.getMeta(player.method_5667(), "fuji.teleport_warmup.warmup", Integer::valueOf);
            int warmup_seconds = permission_warmup_time.orElse(TeleportWarmupInitializer.config.model().warmup_second);
            ticket = TeleportTicket.make(player, GlobalPos.of(player), new GlobalPos((class_1937)serverWorld, x, y, z, yaw, pitch), warmup_seconds * 1000, TeleportWarmupInitializer.config.model().interruptible, set);
            Managers.getBossBarManager().addTicket(ticket);
            cir.cancel();
        } else if (!ticket.isCompleted()) {
            TextHelper.sendActionBarByKey(player, "teleport_warmup.another_teleportation_in_progress", new Object[0]);
            cir.cancel();
        }
    }
}

