/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.launcher;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.command.argument.wrapper.impl.EntityCollection;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.entity.LivingEntityDamageEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_3532;
import net.minecraft.class_8111;
import org.jetbrains.annotations.NotNull;

@Document(id=1756347408511L, value="Launch a target `entity` in specified `direction` and `power`.\n")
@ColorBoxes(value={@ColorBox(id=1757527645811L, color=ColorBox.ColorBoxTypes.TIP, value="\u25c9 Create a `jump pad` that launches players when stepped on.\nYou can integrate with `command_attachment` module.\nIssue: `/command-attachment attach-block-one ~ ~ ~ --interactType STEP_ON \\<command\\>`\n\n\u25c9 Create a `knock-back stick` that kick the entities around you.\nIssue: `/command-attachment attach-item-one launch at %player:name% @e[type=!minecraft:player,distance=..8] 30 1`\n"), @ColorBox(id=1756440410476L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Use a lower `angle` for `fast horizontal movement`.\n1. `/launch facing @s 15 1`\n2. `/launch facing @s 15 3.9`\n<green>The `power` is clamped in `[-3.9, +3.9]`\n\n\u25c9 Use a median `angle` for `balanced horizontal and vertical movement`.\n1. `/launch facing @s 30 3.9`\n2. `/launch facing @s 45 3.9`\n\n\u25c9 Use a higher `angle` for a `rocket launcher` effect.\nIssue: `/launch facing @s 60 3.9`\n<green>TIP: Remember to bring your `elytra`.\n\n\u25c9 Use a `vertical angle` for a `trampoline` effect.\nIssue: `/launch facing @s 90 1`\n\n\u25c9 Use a `positive power` for a `push` effect.\nIssue: `/launch facing @s 0 1`\n\n\u25c9 Use a `negative power` for a `pull` effect.\nIssue: `/launch facing @s 0 -1`\n\n\u25c9 Use another entity's perspective as the direction, to `kick` the target entity.\nIssue: `/launch at @s @e[type=!minecraft:player,distance=..8] 30 1`\n")})
public class LauncherInitializer
extends ModuleInitializer {
    public static Set<class_1297> LAUNCHED_ENTITIES = new HashSet<class_1297>();

    private static void launchEntityFacing(@NotNull class_1297 player, float angle, double power) {
        LauncherInitializer.launchEntity(player, player.method_36454(), angle, power);
    }

    private static void launchEntityAt(@NotNull class_1297 player, @NotNull class_1297 at, float angle, double power) {
        LauncherInitializer.launchEntity(player, at.method_36454(), angle, power);
    }

    public static void launchEntity(@NotNull class_1297 entity, float perspectiveYaw, float perspectivePitch, double power) {
        float yaw = perspectiveYaw * ((float)Math.PI / 180);
        float pitch = perspectivePitch * ((float)Math.PI / 180);
        double x = -Math.sin(yaw) * Math.cos(pitch);
        double y = Math.sin(pitch);
        double z = Math.cos(yaw) * Math.cos(pitch);
        double length = Math.sqrt(x * x + y * y + z * z);
        power = class_3532.method_15350((double)power, (double)-3.9f, (double)3.9f);
        entity.method_18800((x /= length) * power, (y /= length) * power, (z /= length) * power);
        entity.field_6037 = true;
    }

    @CommandNode(value="launch facing")
    @CommandRequirement(level=4)
    private static int $launch(@CommandSource class_2168 source, EntityCollection target, float angle, double power) {
        ((Collection)target.getValue()).forEach(entity -> {
            LAUNCHED_ENTITIES.add((class_1297)entity);
            LauncherInitializer.launchEntityFacing(entity, angle, power);
        });
        return 1;
    }

    @CommandNode(value="launch at")
    @CommandRequirement(level=4)
    private static int $launch(@CommandSource class_2168 source, class_1297 at, EntityCollection target, float angle, double power) {
        ((Collection)target.getValue()).forEach(entity -> {
            LAUNCHED_ENTITIES.add((class_1297)entity);
            LauncherInitializer.launchEntityAt(entity, at, angle, power);
        });
        return 1;
    }

    @EventConsumer
    private static void safelyLanding(LivingEntityDamageEvent event) {
        class_1309 entity = event.getLivingEntity();
        if (!LAUNCHED_ENTITIES.contains(entity)) {
            return;
        }
        class_1282 damageSource = event.getDamageSource();
        boolean immuneToThisDamageType = damageSource.method_48793().method_40230().map(key -> key.equals(class_8111.field_42345)).orElse(false);
        if (immuneToThisDamageType) {
            LAUNCHED_ENTITIES.remove(entity);
            event.setDamage(0.0f);
        }
    }
}

