/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.mixin.gameplay.carpet.fake_player_manager;

import carpet.commands.PlayerCommand;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import mod.fuji.core.auxiliary.minecraft.CommandHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.module.initializer.gameplay.carpet.fake_player_manager.service.FakePlayerManagerService;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={PlayerCommand.class})
public abstract class PlayerCommandMixin {
    @WrapOperation(method={"cantSpawn"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;")}, remap=false)
    @NotNull
    private static String modifyFakePlayerNameForCantSpawnMethod(CommandContext<?> context, String name, Operation<String> original) {
        return FakePlayerManagerService.getTransformedFakePlayerName(StringArgumentType.getString(context, (String)name));
    }

    @WrapOperation(method={"spawn"}, at={@At(value="INVOKE", target="Lcom/mojang/brigadier/arguments/StringArgumentType;getString(Lcom/mojang/brigadier/context/CommandContext;Ljava/lang/String;)Ljava/lang/String;")}, remap=false)
    @NotNull
    private static String modifyFakePlayerNameForSpawnMethod(CommandContext<?> context, String name, Operation<String> original) {
        return FakePlayerManagerService.getTransformedFakePlayerName(StringArgumentType.getString(context, (String)name));
    }

    @Inject(method={"spawn"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void checkFakePlayerCapsOnSpawnCommand(@NotNull CommandContext<class_2168> context, @NotNull CallbackInfoReturnable<Integer> cir) {
        if (CommandHelper.Source.isExecutedByConsole(context)) {
            return;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        if (!FakePlayerManagerService.canSpawnMoreFakePlayers(player)) {
            TextHelper.sendTextByKey(player, "fake_player_manager.spawn.limit_exceed", new Object[0]);
            cir.setReturnValue((Object)0);
        }
    }

    @Inject(method={"spawn"}, at={@At(value="TAIL")}, remap=false)
    private static void trackSpawnedFakePlayerOnSpawnCommand(@NotNull CommandContext<class_2168> context, CallbackInfoReturnable<Integer> cir) {
        if (CommandHelper.Source.isExecutedByConsole(context)) {
            return;
        }
        class_3222 player = ((class_2168)context.getSource()).method_44023();
        String fakePlayerName = StringArgumentType.getString(context, (String)"player");
        fakePlayerName = FakePlayerManagerService.getTransformedFakePlayerName(fakePlayerName);
        FakePlayerManagerService.addMyFakePlayer(player, fakePlayerName);
        FakePlayerManagerService.renewMyFakePlayers(player);
    }

    @Inject(method={"cantManipulate"}, at={@At(value="HEAD")}, remap=false, cancellable=true)
    private static void validateAuthorityOnPlayerCommands(@NotNull CommandContext<class_2168> context, @NotNull CallbackInfoReturnable<Boolean> cir) {
        String fakePlayerName = StringArgumentType.getString(context, (String)"player");
        if (!FakePlayerManagerService.canManipulateFakePlayer(context, fakePlayerName)) {
            TextHelper.sendTextByKey(context.getSource(), "fake_player_manager.manipulate.forbidden", new Object[0]);
            cir.setReturnValue((Object)true);
        }
    }
}

