/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import com.mojang.authlib.properties.PropertyMap;
import java.util.UUID;
import mod.fuji.core.auxiliary.LogUtil;
import net.minecraft.class_3312;
import org.jetbrains.annotations.NotNull;

public class AuthlibHelper {
    public static String getPropertyName(@NotNull Property property) {
        return property.name();
    }

    public static String getPropertyValue(@NotNull Property property) {
        return property.value();
    }

    public static String getPropertySignature(@NotNull Property property) {
        return property.signature();
    }

    public static void modifyGameProfile(@NotNull GameProfile gameProfile, @NotNull Property skin) {
        String name = AuthlibHelper.getName(gameProfile);
        LogUtil.debug("Modify the skin property for player {}. (skin = {})", name, skin);
        PropertyMap properties = AuthlibHelper.getProperties(gameProfile);
        properties.removeAll((Object)"textures");
        properties.put((Object)"textures", (Object)skin);
    }

    @NotNull
    public static String getName(@NotNull GameProfile gameProfile) {
        return gameProfile.getName();
    }

    @NotNull
    public static UUID getId(@NotNull GameProfile gameProfile) {
        return gameProfile.getId();
    }

    @NotNull
    public static PropertyMap getProperties(@NotNull GameProfile gameProfile) {
        return gameProfile.getProperties();
    }

    @NotNull
    public static PropertyMap makePropertyMap() {
        return AuthlibHelper.makePropertyMap((Multimap<String, Property>)LinkedHashMultimap.create());
    }

    @NotNull
    public static PropertyMap makePropertyMap(@NotNull Multimap<String, Property> properties) {
        PropertyMap propertyMap = new PropertyMap();
        propertyMap.putAll(properties);
        return propertyMap;
    }

    @NotNull
    public static GameProfile getGameProfile(@NotNull class_3312.class_3313 entry) {
        return entry.method_14519();
    }
}

