/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.document.descriptor;

import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.core.document.interfaces.SourceModuleGetter;
import mod.fuji.core.module.ModuleLoadDeterminer;
import mod.fuji.core.module.ModulePathResolver;
import net.minecraft.class_1792;
import org.jetbrains.annotations.NotNull;

public abstract class StringDescriptor
implements SourceModuleGetter {
    public static final List<StringDescriptor> REGISTERED_STRING_DESCRIPTORS = new ArrayList<StringDescriptor>();
    private final String pattern;
    private String string;
    private final long docStringId;
    private final String fromModule;

    @NotNull
    public String getDocumentString(Object audience) {
        return DocumentUtil.getDocString(audience, this.docStringId);
    }

    private void compilePattern() {
        this.string = this.pattern.replaceAll("<.*?>", "%s");
    }

    public StringDescriptor(@NotNull String pattern, long docStringId) {
        this(false, pattern, docStringId);
    }

    public StringDescriptor(boolean temporary, @NotNull String pattern, long docStringId) {
        this.pattern = pattern;
        this.docStringId = docStringId;
        this.fromModule = ReflectionUtil.Stacktrace.findSourceModuleInCurrentStackTrace();
        this.compilePattern();
        this.tryRegister(temporary, this.fromModule);
    }

    private void tryRegister(boolean temporary, String sourceModule) {
        if (temporary) {
            return;
        }
        List<String> modulePathList = ModulePathResolver.toModulePathList(sourceModule);
        Boolean moduleEnableStatus = ModuleLoadDeterminer.MODULE_ENABLE_STATUS.getOrDefault(modulePathList, false);
        if (moduleEnableStatus.booleanValue()) {
            REGISTERED_STRING_DESCRIPTORS.add(this);
        }
    }

    public int sortPriority() {
        return 0;
    }

    public abstract String getStringType();

    public abstract class_1792 toItem();

    public String withArguments(Object ... arguments) {
        if (arguments.length != 0) {
            return this.string.formatted(arguments);
        }
        return this.string;
    }

    @Override
    @NotNull
    public String getSourceModule() {
        return this.fromModule;
    }

    @NotNull
    public abstract String toNameString();

    @Generated
    public String getPattern() {
        return this.pattern;
    }

    @Generated
    public String getString() {
        return this.string;
    }

    @Generated
    public long getDocStringId() {
        return this.docStringId;
    }

    @Generated
    public String getFromModule() {
        return this.fromModule;
    }

    @Generated
    public StringDescriptor setString(String string) {
        this.string = string;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof StringDescriptor)) {
            return false;
        }
        StringDescriptor other = (StringDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getDocStringId() != other.getDocStringId()) {
            return false;
        }
        String this$pattern = this.getPattern();
        String other$pattern = other.getPattern();
        if (this$pattern == null ? other$pattern != null : !this$pattern.equals(other$pattern)) {
            return false;
        }
        String this$string = this.getString();
        String other$string = other.getString();
        if (this$string == null ? other$string != null : !this$string.equals(other$string)) {
            return false;
        }
        String this$fromModule = this.getFromModule();
        String other$fromModule = other.getFromModule();
        return !(this$fromModule == null ? other$fromModule != null : !this$fromModule.equals(other$fromModule));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof StringDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $docStringId = this.getDocStringId();
        result = result * 59 + (int)($docStringId >>> 32 ^ $docStringId);
        String $pattern = this.getPattern();
        result = result * 59 + ($pattern == null ? 43 : $pattern.hashCode());
        String $string = this.getString();
        result = result * 59 + ($string == null ? 43 : $string.hashCode());
        String $fromModule = this.getFromModule();
        result = result * 59 + ($fromModule == null ? 43 : $fromModule.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "StringDescriptor(pattern=" + this.getPattern() + ", string=" + this.getString() + ", docStringId=" + this.getDocStringId() + ", fromModule=" + this.getFromModule() + ")";
    }
}

