/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_menu.structure;

import eu.pb4.sgui.api.ClickType;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.GuiHelper;
import mod.fuji.core.auxiliary.minecraft.ItemStackHelper;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.module.initializer.command_menu.CommandMenuInitializer;
import mod.fuji.module.initializer.command_menu.structure.MenuDescriptor;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SlotDescriptor {
    @DocStringProvider(id=1751999474601L, value="To view this slot, you need the defined `specified permission` for this slot.\n")
    private static final PermissionDescriptor SLOT_VIEW_REQUIREMENT_PERMISSION = new PermissionDescriptor("<specified-permission>", 1751999474601L);
    @Document(id=1751824853240L, value="Where to place this item in GUI?\n")
    private int index = 0;
    @Document(id=1756620040668L, value="Also place this item in these specified indexes.\n")
    private List<Integer> otherIndexes = new ArrayList<Integer>();
    @Document(id=1756620062788L, value="Whether to place this item in all blank slots.\n")
    private boolean fillBlankIndexes = false;
    @Document(id=1751824861377L, value="What is the item?\n")
    private String item = "minecraft:stone";
    @Document(id=1751824865422L, value="The count of this item.\n")
    private int count = 42;
    @Document(id=1751824870793L, value="The display name of this item.\n")
    @Nullable
    private String displayName = "<blue>My Nice Item Name";
    private boolean hideTooltip = false;
    @Document(id=1751824877459L, value="Should we glow this item?\n")
    private boolean glow = false;
    @Document(id=1751824881740L, value="The lore of this item.\n")
    private List<String> lore = new ArrayList<String>(){
        {
            this.add("<green>Hello %player:name%");
            this.add("<yellow>You are in %world:id%");
        }
    };
    @Document(id=1751824886812L, value="The `requirement` to `see` this item in GUI.\n")
    private ViewRequirement viewRequirement = new ViewRequirement();
    private Commands commands = new Commands();

    public boolean canViewThisSlot(class_3222 player) {
        if (!player.method_64475(this.viewRequirement.level)) {
            return false;
        }
        return this.viewRequirement.string == null || this.viewRequirement.string.isEmpty() || LuckpermsHelper.hasPermission(player.method_5667(), SLOT_VIEW_REQUIREMENT_PERMISSION, this.viewRequirement.string);
    }

    public GuiElementInterface buildGuiElement(class_3222 viewingPlayer, MenuDescriptor menuDescriptor) {
        class_1799 itemStack = ItemStackHelper.Parser.parseItemStack(this.item);
        GuiElementBuilder slotElementBuilder = GuiElementBuilder.from((class_1799)itemStack);
        slotElementBuilder.setCount(this.count);
        if (this.hideTooltip) {
            GuiHelper.hideTooltip(slotElementBuilder);
        }
        if (this.glow) {
            slotElementBuilder.glow();
        }
        if (this.displayName != null) {
            class_2561 displayName = TextHelper.getTextByValue(viewingPlayer, this.displayName, new Object[0]);
            slotElementBuilder.setName(displayName);
        }
        if (this.lore != null && !this.lore.isEmpty()) {
            ArrayList lore = new ArrayList();
            this.lore.forEach(it -> lore.add(TextHelper.getTextByValue(viewingPlayer, it, new Object[0])));
            slotElementBuilder.setLore(lore);
        }
        slotElementBuilder.setCallback((GuiElementInterface.ClickCallback)new CommandMenuSlotClickCallback(viewingPlayer, menuDescriptor, this));
        return slotElementBuilder.build();
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public List<Integer> getOtherIndexes() {
        return this.otherIndexes;
    }

    @Generated
    public boolean isFillBlankIndexes() {
        return this.fillBlankIndexes;
    }

    @Generated
    public String getItem() {
        return this.item;
    }

    @Generated
    public int getCount() {
        return this.count;
    }

    @Nullable
    @Generated
    public String getDisplayName() {
        return this.displayName;
    }

    @Generated
    public boolean isHideTooltip() {
        return this.hideTooltip;
    }

    @Generated
    public boolean isGlow() {
        return this.glow;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public ViewRequirement getViewRequirement() {
        return this.viewRequirement;
    }

    @Generated
    public Commands getCommands() {
        return this.commands;
    }

    @Generated
    public SlotDescriptor setIndex(int index) {
        this.index = index;
        return this;
    }

    @Generated
    public SlotDescriptor setOtherIndexes(List<Integer> otherIndexes) {
        this.otherIndexes = otherIndexes;
        return this;
    }

    @Generated
    public SlotDescriptor setFillBlankIndexes(boolean fillBlankIndexes) {
        this.fillBlankIndexes = fillBlankIndexes;
        return this;
    }

    @Generated
    public SlotDescriptor setItem(String item) {
        this.item = item;
        return this;
    }

    @Generated
    public SlotDescriptor setCount(int count) {
        this.count = count;
        return this;
    }

    @Generated
    public SlotDescriptor setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Generated
    public SlotDescriptor setHideTooltip(boolean hideTooltip) {
        this.hideTooltip = hideTooltip;
        return this;
    }

    @Generated
    public SlotDescriptor setGlow(boolean glow) {
        this.glow = glow;
        return this;
    }

    @Generated
    public SlotDescriptor setLore(List<String> lore) {
        this.lore = lore;
        return this;
    }

    @Generated
    public SlotDescriptor setViewRequirement(ViewRequirement viewRequirement) {
        this.viewRequirement = viewRequirement;
        return this;
    }

    @Generated
    public SlotDescriptor setCommands(Commands commands) {
        this.commands = commands;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SlotDescriptor)) {
            return false;
        }
        SlotDescriptor other = (SlotDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getIndex() != other.getIndex()) {
            return false;
        }
        if (this.isFillBlankIndexes() != other.isFillBlankIndexes()) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        if (this.isHideTooltip() != other.isHideTooltip()) {
            return false;
        }
        if (this.isGlow() != other.isGlow()) {
            return false;
        }
        List<Integer> this$otherIndexes = this.getOtherIndexes();
        List<Integer> other$otherIndexes = other.getOtherIndexes();
        if (this$otherIndexes == null ? other$otherIndexes != null : !((Object)this$otherIndexes).equals(other$otherIndexes)) {
            return false;
        }
        String this$item = this.getItem();
        String other$item = other.getItem();
        if (this$item == null ? other$item != null : !this$item.equals(other$item)) {
            return false;
        }
        String this$displayName = this.getDisplayName();
        String other$displayName = other.getDisplayName();
        if (this$displayName == null ? other$displayName != null : !this$displayName.equals(other$displayName)) {
            return false;
        }
        List<String> this$lore = this.getLore();
        List<String> other$lore = other.getLore();
        if (this$lore == null ? other$lore != null : !((Object)this$lore).equals(other$lore)) {
            return false;
        }
        ViewRequirement this$viewRequirement = this.getViewRequirement();
        ViewRequirement other$viewRequirement = other.getViewRequirement();
        if (this$viewRequirement == null ? other$viewRequirement != null : !((Object)this$viewRequirement).equals(other$viewRequirement)) {
            return false;
        }
        Commands this$commands = this.getCommands();
        Commands other$commands = other.getCommands();
        return !(this$commands == null ? other$commands != null : !((Object)this$commands).equals(other$commands));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof SlotDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getIndex();
        result = result * 59 + (this.isFillBlankIndexes() ? 79 : 97);
        result = result * 59 + this.getCount();
        result = result * 59 + (this.isHideTooltip() ? 79 : 97);
        result = result * 59 + (this.isGlow() ? 79 : 97);
        List<Integer> $otherIndexes = this.getOtherIndexes();
        result = result * 59 + ($otherIndexes == null ? 43 : ((Object)$otherIndexes).hashCode());
        String $item = this.getItem();
        result = result * 59 + ($item == null ? 43 : $item.hashCode());
        String $displayName = this.getDisplayName();
        result = result * 59 + ($displayName == null ? 43 : $displayName.hashCode());
        List<String> $lore = this.getLore();
        result = result * 59 + ($lore == null ? 43 : ((Object)$lore).hashCode());
        ViewRequirement $viewRequirement = this.getViewRequirement();
        result = result * 59 + ($viewRequirement == null ? 43 : ((Object)$viewRequirement).hashCode());
        Commands $commands = this.getCommands();
        result = result * 59 + ($commands == null ? 43 : ((Object)$commands).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "SlotDescriptor(index=" + this.getIndex() + ", otherIndexes=" + String.valueOf(this.getOtherIndexes()) + ", fillBlankIndexes=" + this.isFillBlankIndexes() + ", item=" + this.getItem() + ", count=" + this.getCount() + ", displayName=" + this.getDisplayName() + ", hideTooltip=" + this.isHideTooltip() + ", glow=" + this.isGlow() + ", lore=" + String.valueOf(this.getLore()) + ", viewRequirement=" + String.valueOf(this.getViewRequirement()) + ", commands=" + String.valueOf(this.getCommands()) + ")";
    }

    @Generated
    public SlotDescriptor() {
    }

    public static class ViewRequirement {
        private int level = 0;
        @Nullable
        private String string = null;

        @Generated
        public int getLevel() {
            return this.level;
        }

        @Nullable
        @Generated
        public String getString() {
            return this.string;
        }

        @Generated
        public ViewRequirement setLevel(int level) {
            this.level = level;
            return this;
        }

        @Generated
        public ViewRequirement setString(@Nullable String string) {
            this.string = string;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ViewRequirement)) {
                return false;
            }
            ViewRequirement other = (ViewRequirement)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            String this$string = this.getString();
            String other$string = other.getString();
            return !(this$string == null ? other$string != null : !this$string.equals(other$string));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ViewRequirement;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLevel();
            String $string = this.getString();
            result = result * 59 + ($string == null ? 43 : $string.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SlotDescriptor.ViewRequirement(level=" + this.getLevel() + ", string=" + this.getString() + ")";
        }

        @Generated
        public ViewRequirement() {
        }
    }

    public record CommandMenuSlotClickCallback(class_3222 viewingPlayer, MenuDescriptor menuDescriptor, SlotDescriptor slotDescriptor) implements GuiElementInterface.ClickCallback
    {
        public void click(int i, ClickType clickType, class_1713 clickType1, @NotNull SlotGuiInterface slotGuiInterface) {
            if (clickType == ClickType.MOUSE_LEFT && !this.slotDescriptor.commands.onLeftClickCommands.isEmpty()) {
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(this.viewingPlayer.method_64396()), this.slotDescriptor.commands.onLeftClickCommands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_RIGHT && !this.slotDescriptor.commands.onRightClickCommands.isEmpty()) {
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(this.viewingPlayer.method_64396()), this.slotDescriptor.commands.onRightClickCommands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_LEFT_SHIFT && !this.slotDescriptor.commands.onLeftShiftClickCommands.isEmpty()) {
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(this.viewingPlayer.method_64396()), this.slotDescriptor.commands.onLeftShiftClickCommands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_RIGHT_SHIFT && !this.slotDescriptor.commands.onRightShiftClickCommands.isEmpty()) {
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(this.viewingPlayer.method_64396()), this.slotDescriptor.commands.onRightShiftClickCommands);
                this.tryCloseThisMenu();
                return;
            }
            if (clickType == ClickType.MOUSE_MIDDLE && !this.slotDescriptor.commands.onMiddleClickCommands.isEmpty()) {
                CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(this.viewingPlayer.method_64396()), this.slotDescriptor.commands.onMiddleClickCommands);
                this.tryCloseThisMenu();
                return;
            }
        }

        private void tryCloseThisMenu() {
            if (this.menuDescriptor.closeMenuOnClicked) {
                CommandMenuInitializer.closeCurrentHandledScreen(this.viewingPlayer);
            }
        }
    }

    public static class Commands {
        private List<String> onLeftClickCommands = new ArrayList<String>(){
            {
                this.add("send-message %player:name% You just clicked me.");
                this.add("chain has-level? %player:name% 4 chain send-message %player:name% <yellow>You are op player.");
                this.add("command-menu close %player:name%");
            }
        };
        private List<String> onLeftShiftClickCommands = new ArrayList<String>();
        private List<String> onRightClickCommands = new ArrayList<String>();
        private List<String> onRightShiftClickCommands = new ArrayList<String>();
        private List<String> onMiddleClickCommands = new ArrayList<String>();

        @Generated
        public List<String> getOnLeftClickCommands() {
            return this.onLeftClickCommands;
        }

        @Generated
        public List<String> getOnLeftShiftClickCommands() {
            return this.onLeftShiftClickCommands;
        }

        @Generated
        public List<String> getOnRightClickCommands() {
            return this.onRightClickCommands;
        }

        @Generated
        public List<String> getOnRightShiftClickCommands() {
            return this.onRightShiftClickCommands;
        }

        @Generated
        public List<String> getOnMiddleClickCommands() {
            return this.onMiddleClickCommands;
        }

        @Generated
        public Commands setOnLeftClickCommands(List<String> onLeftClickCommands) {
            this.onLeftClickCommands = onLeftClickCommands;
            return this;
        }

        @Generated
        public Commands setOnLeftShiftClickCommands(List<String> onLeftShiftClickCommands) {
            this.onLeftShiftClickCommands = onLeftShiftClickCommands;
            return this;
        }

        @Generated
        public Commands setOnRightClickCommands(List<String> onRightClickCommands) {
            this.onRightClickCommands = onRightClickCommands;
            return this;
        }

        @Generated
        public Commands setOnRightShiftClickCommands(List<String> onRightShiftClickCommands) {
            this.onRightShiftClickCommands = onRightShiftClickCommands;
            return this;
        }

        @Generated
        public Commands setOnMiddleClickCommands(List<String> onMiddleClickCommands) {
            this.onMiddleClickCommands = onMiddleClickCommands;
            return this;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Commands)) {
                return false;
            }
            Commands other = (Commands)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$onLeftClickCommands = this.getOnLeftClickCommands();
            List<String> other$onLeftClickCommands = other.getOnLeftClickCommands();
            if (this$onLeftClickCommands == null ? other$onLeftClickCommands != null : !((Object)this$onLeftClickCommands).equals(other$onLeftClickCommands)) {
                return false;
            }
            List<String> this$onLeftShiftClickCommands = this.getOnLeftShiftClickCommands();
            List<String> other$onLeftShiftClickCommands = other.getOnLeftShiftClickCommands();
            if (this$onLeftShiftClickCommands == null ? other$onLeftShiftClickCommands != null : !((Object)this$onLeftShiftClickCommands).equals(other$onLeftShiftClickCommands)) {
                return false;
            }
            List<String> this$onRightClickCommands = this.getOnRightClickCommands();
            List<String> other$onRightClickCommands = other.getOnRightClickCommands();
            if (this$onRightClickCommands == null ? other$onRightClickCommands != null : !((Object)this$onRightClickCommands).equals(other$onRightClickCommands)) {
                return false;
            }
            List<String> this$onRightShiftClickCommands = this.getOnRightShiftClickCommands();
            List<String> other$onRightShiftClickCommands = other.getOnRightShiftClickCommands();
            if (this$onRightShiftClickCommands == null ? other$onRightShiftClickCommands != null : !((Object)this$onRightShiftClickCommands).equals(other$onRightShiftClickCommands)) {
                return false;
            }
            List<String> this$onMiddleClickCommands = this.getOnMiddleClickCommands();
            List<String> other$onMiddleClickCommands = other.getOnMiddleClickCommands();
            return !(this$onMiddleClickCommands == null ? other$onMiddleClickCommands != null : !((Object)this$onMiddleClickCommands).equals(other$onMiddleClickCommands));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Commands;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $onLeftClickCommands = this.getOnLeftClickCommands();
            result = result * 59 + ($onLeftClickCommands == null ? 43 : ((Object)$onLeftClickCommands).hashCode());
            List<String> $onLeftShiftClickCommands = this.getOnLeftShiftClickCommands();
            result = result * 59 + ($onLeftShiftClickCommands == null ? 43 : ((Object)$onLeftShiftClickCommands).hashCode());
            List<String> $onRightClickCommands = this.getOnRightClickCommands();
            result = result * 59 + ($onRightClickCommands == null ? 43 : ((Object)$onRightClickCommands).hashCode());
            List<String> $onRightShiftClickCommands = this.getOnRightShiftClickCommands();
            result = result * 59 + ($onRightShiftClickCommands == null ? 43 : ((Object)$onRightShiftClickCommands).hashCode());
            List<String> $onMiddleClickCommands = this.getOnMiddleClickCommands();
            result = result * 59 + ($onMiddleClickCommands == null ? 43 : ((Object)$onMiddleClickCommands).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SlotDescriptor.Commands(onLeftClickCommands=" + String.valueOf(this.getOnLeftClickCommands()) + ", onLeftShiftClickCommands=" + String.valueOf(this.getOnLeftShiftClickCommands()) + ", onRightClickCommands=" + String.valueOf(this.getOnRightClickCommands()) + ", onRightShiftClickCommands=" + String.valueOf(this.getOnRightShiftClickCommands()) + ", onMiddleClickCommands=" + String.valueOf(this.getOnMiddleClickCommands()) + ")";
        }

        @Generated
        public Commands() {
        }
    }
}

