/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.chat.spy;

import java.util.function.Function;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.annotation.CommandNode;
import mod.fuji.core.command.annotation.CommandRequirement;
import mod.fuji.core.command.annotation.CommandSource;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerChatMessageSentEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.chat.spy.config.model.ChatSpyConfigModel;
import mod.fuji.module.initializer.chat.spy.config.model.ChatSpyDataModel;
import net.minecraft.class_1657;
import net.minecraft.class_2556;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;

@Document(id=1751826708198L, value="This module allows spying on specified `chat message types`. (Primarily private messages types.)\n")
@ColorBox(id=1751899727098L, color=ColorBox.ColorBoxTypes.NOTE, value="Pick a good implementation of `chat spy` in fabric platform is hard.\nIn vanilla Minecraft, each chat message has its `message type`.\nYou can identify the `private chat` from its `message type`.\nThough not all other chat mods respect this point.\nYou can issue `/fuji debug` to enable the `debug mode`.\nAnd see how the `chat.spy` module works.\n")
@CommandNode(value="chat spy")
@CommandRequirement(level=4)
public class ChatSpyInitializer
extends ModuleInitializer {
    private static String lastContentString = "";
    private static final BaseConfigurationHandler<ChatSpyConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", ChatSpyConfigModel.class);
    private static final BaseConfigurationHandler<ChatSpyDataModel> data = ObjectConfigurationHandler.ofModule("data.json", ChatSpyDataModel.class);

    @Document(id=1751826711342L, value="Enable/disable the chat spy mode for you.")
    @CommandNode(value="toggle")
    private static int $toggle(@CommandSource class_3222 player) {
        ChatSpyInitializer.withPlayerOptions(player, true, playerOptions -> {
            playerOptions.setEnabled(!playerOptions.isEnabled());
            TextHelper.sendTextByKey(player, playerOptions.isEnabled() ? "on" : "off", new Object[0]);
            return null;
        });
        return 1;
    }

    private static <T> T withPlayerOptions(@NotNull class_3222 player, boolean writeStorage, @NotNull Function<ChatSpyDataModel.PerPlayerOptions, T> function) {
        String key = PlayerHelper.getPlayerName((class_1657)player);
        ChatSpyDataModel.PerPlayerOptions playerOptions = data.model().getOptions().computeIfAbsent(key, k -> new ChatSpyDataModel.PerPlayerOptions());
        T apply = function.apply(playerOptions);
        if (writeStorage) {
            data.writeStorage();
        }
        return apply;
    }

    private static void processChatSpy(@NotNull String messageTypeString, @NotNull class_3222 receiverPlayer, @NotNull class_2561 contentText) {
        String contentString = TextHelper.Operators.getString(contentText);
        LogUtil.debug("Process chat spy: message type = {}, content string = {}", messageTypeString, contentString);
        if (config.model().getMessageType().getAcceptors().stream().noneMatch(it -> it.matches(messageTypeString))) {
            return;
        }
        if (config.model().isIgnoreConsecutiveSameText() && contentString.equals(lastContentString)) {
            return;
        }
        lastContentString = contentString;
        class_2561 receiverPlayerName = receiverPlayer.method_5476();
        class_5250 notificationText = class_2561.method_43473();
        notificationText.method_10852(contentText).method_10852(TextHelper.TEXT_SPACE).method_10852(TextHelper.getTextByKey(null, "chat.spy.indicator", new Object[0])).method_10852(TextHelper.TEXT_SPACE).method_10852(receiverPlayerName);
        if (config.model().isLogConsole()) {
            LogUtil.info(notificationText.getString(), new Object[0]);
        }
        PlayerHelper.Lookup.getOnlinePlayers().stream().filter(it -> ChatSpyInitializer.withPlayerOptions(it, false, ChatSpyDataModel.PerPlayerOptions::isEnabled)).forEach(it -> TextHelper.sendMessageByText(it, (class_2561)notificationText));
    }

    @EventConsumer(injectorPriority=2000, consumerPriority=999)
    private static void consumePlayerChatMessageSentEvent(PlayerChatMessageSentEvent event) {
        class_2556.class_7602 parameters = event.getParameters();
        String messageTypeString = RegistryHelper.getIdAsString(parameters);
        class_7471 signedMessage = event.getSignedMessage();
        class_2561 contentText = parameters.method_44837(signedMessage.method_46291());
        ChatSpyInitializer.processChatSpy(messageTypeString, event.getReceiverPlayer(), contentText);
    }
}

