/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.economy.structure;

import com.mojang.authlib.GameProfile;
import eu.pb4.common.economy.api.EconomyAccount;
import eu.pb4.common.economy.api.EconomyCurrency;
import eu.pb4.common.economy.api.EconomyProvider;
import eu.pb4.common.economy.api.EconomyTransaction;
import java.util.UUID;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.module.initializer.economy.EconomyInitializer;
import mod.fuji.module.initializer.economy.config.structure.CustomEconomyAccountNode;
import mod.fuji.module.initializer.economy.config.structure.CustomEconomyCurrencyDescriptor;
import mod.fuji.module.initializer.economy.service.EconomyService;
import mod.fuji.module.initializer.economy.structure.CustomEconomyProvider;
import mod.fuji.module.initializer.economy.structure.CustomEconomyTransaction;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CustomEconomyAccount
implements EconomyAccount {
    @Nullable
    private final GameProfile gameProfile;
    @NotNull
    private final CustomEconomyCurrencyDescriptor currencyDescriptor;

    public CustomEconomyAccount(@NotNull GameProfile gameProfile, @NotNull CustomEconomyCurrencyDescriptor currencyDescriptor) {
        this.gameProfile = gameProfile;
        this.currencyDescriptor = currencyDescriptor;
    }

    public class_2561 name() {
        return TextHelper.getTextByValue(this.gameProfile, this.currencyDescriptor.currencyName, new Object[0]);
    }

    public UUID owner() {
        if (this.gameProfile != null) {
            return AuthlibHelper.getId(this.gameProfile);
        }
        return class_156.field_25140;
    }

    public class_2960 id() {
        return RegistryHelper.makeIdentifierOrThrow(this.currencyDescriptor.currencyId);
    }

    public long balance() {
        CustomEconomyAccountNode accountNode = EconomyService.getCustomAccountNode(this.gameProfile, this.currencyDescriptor.toIdentifier());
        return accountNode.balance;
    }

    public void setBalance(long value) {
        CustomEconomyAccountNode accountNode = EconomyService.getCustomAccountNode(this.gameProfile, this.currencyDescriptor.toIdentifier());
        accountNode.balance = value;
        EconomyInitializer.data.writeStorage();
    }

    public EconomyTransaction canIncreaseBalance(long value) {
        return this.makeEconomyTransaction(value);
    }

    public EconomyTransaction canDecreaseBalance(long value) {
        return this.makeEconomyTransaction(-value);
    }

    private EconomyTransaction makeEconomyTransaction(long deltaValue) {
        class_2561 feedbackText;
        boolean isSuccessful;
        long transactionAmount;
        long previousBalance = this.balance();
        long finalBalance = previousBalance + (transactionAmount = deltaValue);
        if (finalBalance < 0L || transactionAmount > 0L && previousBalance > Long.MAX_VALUE - transactionAmount || transactionAmount < 0L && previousBalance < Long.MIN_VALUE - transactionAmount) {
            isSuccessful = false;
            finalBalance = previousBalance;
            feedbackText = TextHelper.getTextByKey(this.gameProfile, "operation.fail", new Object[0]);
        } else {
            isSuccessful = true;
            feedbackText = TextHelper.getTextByKey(this.gameProfile, "operation.success", new Object[0]);
        }
        return new CustomEconomyTransaction(this, isSuccessful, feedbackText, previousBalance, transactionAmount, finalBalance);
    }

    public EconomyProvider provider() {
        return CustomEconomyProvider.INSTANCE;
    }

    public EconomyCurrency currency() {
        return CustomEconomyProvider.getCustomEconomyCurrency(this.currencyDescriptor.toIdentifier());
    }
}

