/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.service.cache;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import mod.fuji.Fuji;
import mod.fuji.core.auxiliary.JsonUtil;
import mod.fuji.core.config.mapper.GsonMapper;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerJoinedEvent;
import mod.fuji.core.service.cache.config.model.GenericCacheModel;
import mod.fuji.core.service.cache.service.GameProfileCacheService;
import mod.fuji.core.service.cache.structure.Cache;
import org.jetbrains.annotations.NotNull;

public class CacheManager {
    private static final Path CACHE_DIRECTORY = Fuji.MOD_CONFIG_PATH.resolve("cache");
    private static final Map<String, GenericCacheModel<?>> CACHE_FILES = new ConcurrentHashMap();

    @EventConsumer
    private static void updateGameProfileCache(PlayerJoinedEvent event) {
        GameProfileCacheService.setGameProfileCache(event.getPlayer());
    }

    @NotNull
    private static Path toCacheFilePath(@NotNull String cacheSubject) {
        Files.createDirectories(CACHE_DIRECTORY.getParent(), new FileAttribute[0]);
        return CACHE_DIRECTORY.resolve(cacheSubject + ".json");
    }

    @NotNull
    public static <T> T getCachedValueOrCompute(@NotNull String cacheSubject, @NotNull String cacheKey, @NotNull Class<T> typeOfCacheValue, @NotNull Duration expirationDuration, @NotNull Supplier<T> supplier) {
        GenericCacheModel model = CacheManager.getGenericCacheModel(cacheSubject, typeOfCacheValue);
        Cache cache = model.getCacheMap().computeIfAbsent(cacheKey, key -> {
            Cache newValue = Cache.of(supplier.get());
            model.setDirty(true);
            return newValue;
        });
        long currentTime = System.currentTimeMillis();
        if (cache.getUpdatedTimestamp() + expirationDuration.toMillis() < currentTime) {
            cache.setValue(supplier.get());
            cache.setUpdatedTimestamp(currentTime);
            model.setDirty(true);
        }
        return cache.getValue();
    }

    @NotNull
    private static <T> GenericCacheModel<T> getGenericCacheModel(@NotNull String cacheSubject, @NotNull Class<T> typeOfValue) {
        GenericCacheModel model = CACHE_FILES.computeIfAbsent(cacheSubject, key -> {
            Path cacheFilePath = CacheManager.toCacheFilePath(cacheSubject);
            CacheManager.writeDefaultCacheModelIfAbsent(cacheFilePath);
            TypeToken typeToken = TypeToken.getParameterized(GenericCacheModel.class, (Type[])new Type[]{typeOfValue});
            return (GenericCacheModel)GsonMapper.fromJson(cacheFilePath, typeToken);
        });
        return model;
    }

    public static void flushGenericCacheModels() {
        CACHE_FILES.forEach((cacheSubject, cacheModel) -> {
            if (!cacheModel.isDirty()) {
                return;
            }
            Path cacheFilePath = CacheManager.toCacheFilePath(cacheSubject);
            JsonObject jsonObject = GsonMapper.toJsonTree(cacheModel).getAsJsonObject();
            JsonUtil.writeJsonObject(jsonObject, cacheFilePath);
            cacheModel.setDirty(false);
        });
    }

    private static void writeDefaultCacheModelIfAbsent(@NotNull Path cacheFilePath) {
        if (!Files.exists(cacheFilePath, new LinkOption[0])) {
            GenericCacheModel defaultModel = new GenericCacheModel();
            JsonElement jsonTree = GsonMapper.toJsonTree(defaultModel);
            JsonUtil.writeJsonObject(jsonTree.getAsJsonObject(), cacheFilePath);
        }
    }
}

