/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.works.structure.work.abst;

import eu.pb4.sgui.api.gui.SimpleGui;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import mod.fuji.core.auxiliary.ChronosUtil;
import mod.fuji.core.auxiliary.RandomUtil;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.ItemStackHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.interfaces.ObjectTypeStringGetter;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.module.initializer.works.gui.WorkGeneralSettingsGui;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Work
implements ObjectTypeStringGetter {
    @Document(id=1751825471703L, value="The type of this work.")
    public String type;
    @Document(id=1751825477130L, value="The unique id of this work.")
    public String id;
    @Document(id=1751825483661L, value="The create time of this work.")
    public long createTimeMS;
    @Document(id=1751825488761L, value="Which player created this work.")
    public String creator;
    @Document(id=1751825493597L, value="The display name of this work.")
    public String name;
    @Document(id=1751825497322L, value="The introduction of this work.")
    @Nullable
    public String introduction;
    public String level;
    public double x;
    public double y;
    public double z;
    public float yaw;
    public float pitch;
    @Document(id=1751825502471L, value="The display item of this work.")
    @Nullable
    public String icon;

    public Work(@NotNull class_3222 player, String name) {
        this.type = this.getObjectTypeString();
        this.id = RandomUtil.randomUUID();
        this.createTimeMS = System.currentTimeMillis();
        this.creator = PlayerHelper.getPlayerName((class_1657)player);
        this.name = name;
        this.introduction = null;
        this.level = RegistryHelper.getIdAsString((class_1937)PlayerHelper.getServerWorld(player));
        this.x = EntityHelper.getPos((class_1297)player).field_1352;
        this.y = EntityHelper.getPos((class_1297)player).field_1351;
        this.z = EntityHelper.getPos((class_1297)player).field_1350;
        this.yaw = player.method_36454();
        this.pitch = player.method_36455();
        this.icon = null;
    }

    protected abstract class_1792 getDefaultEntityIcon();

    public class_1799 getEntityIcon() {
        if (this.icon == null) {
            return this.getDefaultEntityIcon().method_7854();
        }
        return ItemStackHelper.Parser.parseItemStack(this.icon);
    }

    public abstract void openSpecializedSettingsGui(class_3222 var1, SimpleGui var2);

    public void openGeneralSettingsGui(@NotNull class_3222 player, @NotNull SimpleGui parentGui) {
        Work work = this;
        new WorkGeneralSettingsGui(parentGui, player, work).open();
    }

    public List<class_2561> ofLore(class_3222 player) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.creator", this.creator));
        if (this.introduction != null) {
            ret.add(TextHelper.getTextByKey(player, "works.work.prop.introduction", this.introduction));
        }
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.time", ChronosUtil.Formatter.formatDate(this.createTimeMS)));
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.dimension", this.level));
        ret.add(TextHelper.getTextByKey(player, "works.work.prop.coordinate", this.x, this.y, this.z));
        return ret;
    }

    @Generated
    public Work() {
    }

    @Generated
    public String getType() {
        return this.type;
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public long getCreateTimeMS() {
        return this.createTimeMS;
    }

    @Generated
    public String getCreator() {
        return this.creator;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Nullable
    @Generated
    public String getIntroduction() {
        return this.introduction;
    }

    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Nullable
    @Generated
    public String getIcon() {
        return this.icon;
    }

    @Generated
    public Work setType(String type) {
        this.type = type;
        return this;
    }

    @Generated
    public Work setId(String id) {
        this.id = id;
        return this;
    }

    @Generated
    public Work setCreateTimeMS(long createTimeMS) {
        this.createTimeMS = createTimeMS;
        return this;
    }

    @Generated
    public Work setCreator(String creator) {
        this.creator = creator;
        return this;
    }

    @Generated
    public Work setName(String name) {
        this.name = name;
        return this;
    }

    @Generated
    public Work setIntroduction(@Nullable String introduction) {
        this.introduction = introduction;
        return this;
    }

    @Generated
    public Work setLevel(String level) {
        this.level = level;
        return this;
    }

    @Generated
    public Work setX(double x) {
        this.x = x;
        return this;
    }

    @Generated
    public Work setY(double y) {
        this.y = y;
        return this;
    }

    @Generated
    public Work setZ(double z) {
        this.z = z;
        return this;
    }

    @Generated
    public Work setYaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    @Generated
    public Work setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    @Generated
    public Work setIcon(@Nullable String icon) {
        this.icon = icon;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Work)) {
            return false;
        }
        Work other = (Work)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCreateTimeMS() != other.getCreateTimeMS()) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$creator = this.getCreator();
        String other$creator = other.getCreator();
        if (this$creator == null ? other$creator != null : !this$creator.equals(other$creator)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$introduction = this.getIntroduction();
        String other$introduction = other.getIntroduction();
        if (this$introduction == null ? other$introduction != null : !this$introduction.equals(other$introduction)) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        if (this$level == null ? other$level != null : !this$level.equals(other$level)) {
            return false;
        }
        String this$icon = this.getIcon();
        String other$icon = other.getIcon();
        return !(this$icon == null ? other$icon != null : !this$icon.equals(other$icon));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Work;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $createTimeMS = this.getCreateTimeMS();
        result = result * 59 + (int)($createTimeMS >>> 32 ^ $createTimeMS);
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $creator = this.getCreator();
        result = result * 59 + ($creator == null ? 43 : $creator.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $introduction = this.getIntroduction();
        result = result * 59 + ($introduction == null ? 43 : $introduction.hashCode());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        String $icon = this.getIcon();
        result = result * 59 + ($icon == null ? 43 : $icon.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "Work(type=" + this.getType() + ", id=" + this.getId() + ", createTimeMS=" + this.getCreateTimeMS() + ", creator=" + this.getCreator() + ", name=" + this.getName() + ", introduction=" + this.getIntroduction() + ", level=" + this.getLevel() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ", icon=" + this.getIcon() + ")";
    }
}

