/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import mod.fuji.core.auxiliary.LogUtil;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class FabricApiHelper {
    private static final String FABRIC_API_EVENT_INVOKER_METHOD_NAME = "invoker";
    private static final String SERVER_WORLD_EVENTS_CLASS_NAME = "net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents";

    private static boolean isFabricApiModInstalled() {
        return FabricLoader.getInstance().isModLoaded("fabric-api");
    }

    public static void fireOnWorldLoadEvent(@NotNull MinecraftServer server, @NotNull class_3218 serverWorld) throws Exception {
        List<Class<?>> eventParameters = List.of(MinecraftServer.class, class_3218.class);
        List<class_3218> eventArguments = List.of(server, serverWorld);
        FabricApiHelper.fireEvent(SERVER_WORLD_EVENTS_CLASS_NAME, "LOAD", "onWorldLoad", eventParameters, eventArguments);
    }

    public static void fireOnWorldUnloadEvent(@NotNull MinecraftServer server, @NotNull class_3218 serverWorld) throws Exception {
        List<Class<?>> eventParameters = List.of(MinecraftServer.class, class_3218.class);
        List<class_3218> eventArguments = List.of(server, serverWorld);
        FabricApiHelper.fireEvent(SERVER_WORLD_EVENTS_CLASS_NAME, "UNLOAD", "onWorldUnload", eventParameters, eventArguments);
    }

    private static void fireEvent(@NotNull String eventDeclaringClassName, @NotNull String eventDeclaringFieldName, @NotNull String eventFireMethodName, @NotNull List<Class<?>> eventFireMethodParameterList, @NotNull List<Object> eventFireMethodArgumentList) throws Exception {
        LogUtil.debug("fireEvent(): try firing an event. (eventDeclaringClassName = {}, eventDeclaringFieldName = {}, eventFireMethodName = {}, eventFireMethodParameterList = {}, eventFireMethodArgumentList = {})", eventDeclaringClassName, eventDeclaringFieldName, eventFireMethodName, eventFireMethodParameterList, eventFireMethodArgumentList);
        if (!FabricApiHelper.isFabricApiModInstalled()) {
            LogUtil.debug("fireEvent(): The `fabric-api` mod is not installed, skip the firing of the event.", new Object[0]);
            return;
        }
        Class<?> eventDeclaringClass = Class.forName(eventDeclaringClassName);
        LogUtil.debug("fireEvent(): Class<?> eventDeclaringClass = {}", eventDeclaringClass);
        Field eventDeclaringField = eventDeclaringClass.getDeclaredField(eventDeclaringFieldName);
        LogUtil.debug("fireEvent(): Field eventDeclaringField = {}", eventDeclaringField);
        eventDeclaringField.setAccessible(true);
        Object eventInstance = eventDeclaringField.get(null);
        Class<?> eventClass = eventInstance.getClass();
        LogUtil.debug("fireEvent(): Object eventInstance = {}", eventInstance);
        Method invokerMethod = eventClass.getMethod(FABRIC_API_EVENT_INVOKER_METHOD_NAME, new Class[0]);
        LogUtil.debug("fireEvent(): Method invokerMethod = {}", invokerMethod);
        Object eventInvokerInstance = invokerMethod.invoke(eventInstance, new Object[0]);
        Class<?> eventInvokerClass = eventInvokerInstance.getClass();
        LogUtil.debug("fireEvent(): Object eventInvokerInstance = {}", eventInvokerInstance);
        Class[] eventFireMethodParameterArray = eventFireMethodParameterList.toArray(new Class[0]);
        Method eventFireMethod = eventInvokerClass.getMethod(eventFireMethodName, eventFireMethodParameterArray);
        Object[] eventFireMethodArgumentArray = eventFireMethodArgumentList.toArray(new Object[0]);
        eventFireMethod.setAccessible(true);
        eventFireMethod.invoke(eventInvokerInstance, eventFireMethodArgumentArray);
    }
}

