/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.config.handler.impl;

import com.google.gson.JsonObject;
import java.nio.file.Path;
import mod.fuji.core.auxiliary.ReflectionUtil;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.validator.RemoveNullElementsInJsonArrayValidator;
import org.jetbrains.annotations.NotNull;

public class ObjectConfigurationHandler<T>
extends BaseConfigurationHandler<T> {
    @NotNull
    private final Class<T> typeOfModel;

    private ObjectConfigurationHandler(@NotNull Path filePath, @NotNull Class<T> typeOfModel) {
        super(filePath);
        this.typeOfModel = typeOfModel;
    }

    @NotNull
    public static <T> ObjectConfigurationHandler<T> ofPath(@NotNull Path path, @NotNull Class<T> typeOfModel) {
        return new ObjectConfigurationHandler<T>(path, typeOfModel);
    }

    @NotNull
    public static <T> ObjectConfigurationHandler<T> ofModule(@NotNull String other, @NotNull Class<T> typeOfModel) {
        Path moduleFilePath = ReflectionUtil.computeModuleConfigPath(typeOfModel).resolve(other);
        return ObjectConfigurationHandler.ofPath(moduleFilePath, typeOfModel);
    }

    @Override
    protected T makeDefaultModel() {
        return this.typeOfModel.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Override
    protected void validateModel(@NotNull JsonObject dataTree, @NotNull JsonObject schemaTree) {
        super.validateModel(dataTree, schemaTree);
        RemoveNullElementsInJsonArrayValidator.validate(dataTree);
    }
}

