/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.structure;

import java.util.regex.Pattern;
import lombok.Generated;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.document.annotation.Document;
import org.jetbrains.annotations.NotNull;

public class RegexRewriteNode {
    @Document(id=1751823950782L, value="The `regex` expression used to match the `target string`.\n")
    private String regex;
    @Document(id=1751823954950L, value="The `pattern` used to replace the `matched target string`.\n")
    private String replacement;
    private transient Pattern pattern;

    public RegexRewriteNode(String regex, String replacement) {
        this.regex = regex;
        this.replacement = replacement;
    }

    @NotNull
    public Pattern getCachedPattern() {
        if (this.pattern == null) {
            try {
                this.pattern = Pattern.compile(this.regex);
            }
            catch (Exception e) {
                LogUtil.error("Failed to compile the regex string '{}'. (Regex Syntax Error)", this.regex, e);
            }
        }
        return this.pattern;
    }

    @Generated
    public String getRegex() {
        return this.regex;
    }

    @Generated
    public String getReplacement() {
        return this.replacement;
    }

    @Generated
    public RegexRewriteNode setRegex(String regex) {
        this.regex = regex;
        return this;
    }

    @Generated
    public RegexRewriteNode setReplacement(String replacement) {
        this.replacement = replacement;
        return this;
    }

    @Generated
    public RegexRewriteNode setPattern(Pattern pattern) {
        this.pattern = pattern;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegexRewriteNode)) {
            return false;
        }
        RegexRewriteNode other = (RegexRewriteNode)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$regex = this.getRegex();
        String other$regex = other.getRegex();
        if (this$regex == null ? other$regex != null : !this$regex.equals(other$regex)) {
            return false;
        }
        String this$replacement = this.getReplacement();
        String other$replacement = other.getReplacement();
        return !(this$replacement == null ? other$replacement != null : !this$replacement.equals(other$replacement));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RegexRewriteNode;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $regex = this.getRegex();
        result = result * 59 + ($regex == null ? 43 : $regex.hashCode());
        String $replacement = this.getReplacement();
        result = result * 59 + ($replacement == null ? 43 : $replacement.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "RegexRewriteNode(regex=" + this.getRegex() + ", replacement=" + this.getReplacement() + ")";
    }

    @Generated
    public RegexRewriteNode() {
    }
}

