/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.structure;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import mod.fuji.core.auxiliary.minecraft.EntityHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.auxiliary.minecraft.WorldHelper;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import org.jetbrains.annotations.NotNull;

public class GlobalPos {
    @NotNull
    private String level;
    private double x;
    private double y;
    private double z;
    private float yaw;
    private float pitch;

    public GlobalPos(@NotNull String world, double x, double y, double z, float yaw, float pitch) {
        this.level = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public GlobalPos(@NotNull class_1937 world, double x, double y, double z, float yaw, float pitch) {
        this(RegistryHelper.getIdAsString(world), x, y, z, yaw, pitch);
    }

    public List<class_2561> asLore(@NotNull class_3222 player) {
        return List.of(TextHelper.getTextByKey(player, "dimension", this.level), TextHelper.getTextByKey(player, "x", this.x), TextHelper.getTextByKey(player, "y", this.y), TextHelper.getTextByKey(player, "z", this.z), TextHelper.getTextByKey(player, "yaw", Float.valueOf(this.yaw)), TextHelper.getTextByKey(player, "pitch", Float.valueOf(this.pitch)));
    }

    @NotNull
    public static GlobalPos of(@NotNull class_1937 world, @NotNull class_2338 blockPos) {
        return new GlobalPos(RegistryHelper.getIdAsString(world), (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 0.0f, 0.0f);
    }

    @NotNull
    public static GlobalPos of(@NotNull class_5321<class_1937> world, @NotNull class_2338 blockPos) {
        return new GlobalPos(RegistryHelper.getIdAsString(world), (double)blockPos.method_10263(), (double)blockPos.method_10264(), (double)blockPos.method_10260(), 0.0f, 0.0f);
    }

    @NotNull
    public static GlobalPos of(@NotNull class_3222 player) {
        class_3218 serverWorld = PlayerHelper.getServerWorld(player);
        return new GlobalPos(RegistryHelper.getIdAsString((class_1937)serverWorld), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
    }

    @NotNull
    public static GlobalPos of(@NotNull class_2168 source) {
        class_1297 entity = source.method_9228();
        if (entity != null) {
            class_3218 serverWorld = EntityHelper.getServerWorld(entity);
            return new GlobalPos(RegistryHelper.getIdAsString((class_1937)serverWorld), entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_36454(), entity.method_36455());
        }
        return new GlobalPos(RegistryHelper.getIdAsString((class_1937)source.method_9225()), source.method_9222().method_10216(), source.method_9222().method_10214(), source.method_9222().method_10215(), source.method_9210().field_1343, source.method_9210().field_1342);
    }

    @NotNull
    public class_2338 toBlockPos() {
        return new class_2338((int)this.x, (int)this.y, (int)this.z);
    }

    public boolean sameLevel(@NotNull class_1937 level) {
        return this.level.equals(RegistryHelper.getIdAsString(level));
    }

    public double distanceToSqr(@NotNull GlobalPos globalPos) {
        if (!this.level.equals(globalPos.level)) {
            return Double.MAX_VALUE;
        }
        double x = this.x - globalPos.x;
        double y = this.y - globalPos.y;
        double z = this.z - globalPos.z;
        return x * x + y * y + z * z;
    }

    public void teleport(@NotNull class_3222 player, Set<class_2709> flags) {
        Optional<class_3218> dimension = WorldHelper.getWorld(this.level);
        dimension.ifPresentOrElse($dimension -> player.method_48105($dimension, this.x, this.y, this.z, flags, this.yaw, this.pitch, true), () -> TextHelper.sendTextByKey(player, "world.dimension.not_found", this.level));
    }

    public void teleport(@NotNull class_3222 player) {
        this.teleport(player, EnumSet.noneOf(class_2709.class));
    }

    @NotNull
    @Generated
    public String getLevel() {
        return this.level;
    }

    @Generated
    public double getX() {
        return this.x;
    }

    @Generated
    public double getY() {
        return this.y;
    }

    @Generated
    public double getZ() {
        return this.z;
    }

    @Generated
    public float getYaw() {
        return this.yaw;
    }

    @Generated
    public float getPitch() {
        return this.pitch;
    }

    @Generated
    public GlobalPos setLevel(@NotNull String level) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        this.level = level;
        return this;
    }

    @Generated
    public GlobalPos setX(double x) {
        this.x = x;
        return this;
    }

    @Generated
    public GlobalPos setY(double y) {
        this.y = y;
        return this;
    }

    @Generated
    public GlobalPos setZ(double z) {
        this.z = z;
        return this;
    }

    @Generated
    public GlobalPos setYaw(float yaw) {
        this.yaw = yaw;
        return this;
    }

    @Generated
    public GlobalPos setPitch(float pitch) {
        this.pitch = pitch;
        return this;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GlobalPos)) {
            return false;
        }
        GlobalPos other = (GlobalPos)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GlobalPos;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "GlobalPos(level=" + this.getLevel() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    @Generated
    public GlobalPos() {
    }

    @Generated
    public GlobalPos withLevel(@NotNull String level) {
        if (level == null) {
            throw new NullPointerException("level is marked non-null but is null");
        }
        return this.level == level ? this : new GlobalPos(level, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    @Generated
    public GlobalPos withX(double x) {
        return this.x == x ? this : new GlobalPos(this.level, x, this.y, this.z, this.yaw, this.pitch);
    }

    @Generated
    public GlobalPos withY(double y) {
        return this.y == y ? this : new GlobalPos(this.level, this.x, y, this.z, this.yaw, this.pitch);
    }

    @Generated
    public GlobalPos withZ(double z) {
        return this.z == z ? this : new GlobalPos(this.level, this.x, this.y, z, this.yaw, this.pitch);
    }

    @Generated
    public GlobalPos withYaw(float yaw) {
        return this.yaw == yaw ? this : new GlobalPos(this.level, this.x, this.y, this.z, yaw, this.pitch);
    }

    @Generated
    public GlobalPos withPitch(float pitch) {
        return this.pitch == pitch ? this : new GlobalPos(this.level, this.x, this.y, this.z, this.yaw, pitch);
    }
}

