/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.anti_build;

import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import mod.fuji.core.auxiliary.minecraft.LuckpermsHelper;
import mod.fuji.core.auxiliary.minecraft.PlayerHelper;
import mod.fuji.core.auxiliary.minecraft.RegistryHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.handler.abst.BaseConfigurationHandler;
import mod.fuji.core.config.handler.impl.ObjectConfigurationHandler;
import mod.fuji.core.document.annotation.ColorBox;
import mod.fuji.core.document.annotation.ColorBoxes;
import mod.fuji.core.document.annotation.DocStringProvider;
import mod.fuji.core.document.annotation.Document;
import mod.fuji.core.document.annotation.TestCase;
import mod.fuji.core.document.descriptor.PermissionDescriptor;
import mod.fuji.core.event.annotation.EventConsumer;
import mod.fuji.core.event.message.player.PlayerBlockBreakPreEvent;
import mod.fuji.core.event.message.player.PlayerInteractBlockPreEvent;
import mod.fuji.core.event.message.player.PlayerInteractEntityPreEvent;
import mod.fuji.core.event.message.player.PlayerInteractItemPreEvent;
import mod.fuji.module.initializer.ModuleInitializer;
import mod.fuji.module.initializer.anti_build.config.model.AntiBuildConfigModel;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Document(id=1751825625507L, value="This module allows restricting specific player `actions`.\n\nCurrently supported `action types` include:\n1. Break a specified block.\n2. Place a specified block.\n3. Interact with a specified item.\n4. Interact with a specified block.\n5. Interact with a specified entity.\n6. Attack a specified entity.\n")
@ColorBoxes(value={@ColorBox(id=1751896813134L, color=ColorBox.ColorBoxTypes.TIP, value="Read the document to see the definition of `identifier` in Minecraft.\n"), @ColorBox(id=1751896904529L, color=ColorBox.ColorBoxTypes.TIP, value="Use the `command suggestion` from `luckperms` mod to see the supported types by this module.\n"), @ColorBox(id=1751897087633L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 To ban the placement of TNT block:\nJust add the `minecraft:tnt` into the `place_block` list in config file.\n\n\u25c9 To ban the placement of TNT block, but allow player Alice to use it.\nGrant a `bypass permission` for that player: `/lp user Alice permission set fuji.anti_build.place_block.bypass.minecraft:tnt`.\n\n\u25c9 To assign a override permission for a player explicitly.\nIssue: `/lp user Alice permission set fuji.anti_build.break_block.override.minecraft:grass_block false`\nThis will `dis-allow` the player Alice to `break a minecraft:grass_block block`.\n\n\u25c9 Dis-allow to place `any` blocks.\nUse `*` as the wildcard character, put it into the `place_block` list.\n"), @ColorBox(id=1753246687639L, color=ColorBox.ColorBoxTypes.EXAMPLE, value="\u25c9 Ban the `placement` of `mushroom` in `minecraft:the_end` dimension.\nIssue:\n1. `/lp group default permission set fuji.anti_build.place_block.override.minecraft:red_mushroom false world=the_end`\n2. `/lp group default permission set fuji.anti_build.place_block.override.minecraft:brown_mushroom false world=the_end`\n")})
@TestCase(action="Test the functionality of this module.", targets={"Check if the anti type hooks remains the identical semantics."})
public class AntiBuildInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<AntiBuildConfigModel> config = ObjectConfigurationHandler.ofModule("config.json", AntiBuildConfigModel.class);
    @DocStringProvider(id=1751999560958L, value="To bypass a specific `anti type` with a specific `id`.\n\nFor example, the permission `fuji.anti_build.place_block.bypass.minecraft:tnt` allows a player to place the TNT block.\n")
    private static final PermissionDescriptor ANTI_BUILD_BYPASS_PERMISSION = new PermissionDescriptor("fuji.anti_build.<anti-type>.bypass.<id>", 1751999560958L);
    @DocStringProvider(id=1752994843864L, value="To `override` a specific `anti type` with a specific `id`.\n\nIf the permission value is `true`, then it means `allow` this action.\nIf the permission value is `false`, then it means `dis-allow` this action.\nIf the permission value is `undefined`, then it means this action is `ignored`.\n")
    private static final PermissionDescriptor ANTI_BUILD_OVERRIDE_PERMISSION = new PermissionDescriptor("fuji.anti_build.<anti-type>.override.<id>", 1752994843864L);

    public static void processAntiBuild(@Nullable class_1657 player, @NotNull String antiType, @NotNull Set<String> ids, @NotNull String id, @NotNull Runnable canceller, @NotNull Supplier<Boolean> feedbackTrigger) {
        PlayerHelper.Kind.withServerPlayerEntity(player, () -> {
            if (AntiBuildInitializer.isThisActionAllowed(player, antiType, ids, id)) {
                return;
            }
            canceller.run();
            if (((Boolean)feedbackTrigger.get()).booleanValue() && player != null) {
                TextHelper.sendTextByKey(player, "anti_build.disallow", new Object[0]);
            }
        });
    }

    public static <T> void processAntiBuild(@Nullable class_1657 player, @NotNull String antiType, @NotNull Set<String> ids, @NotNull String id, @NotNull CallbackInfoReturnable<T> cir, @NotNull T cancelWithValue, @NotNull Supplier<Boolean> feedbackTrigger) {
        AntiBuildInitializer.processAntiBuild(player, antiType, ids, id, () -> cir.setReturnValue(cancelWithValue), feedbackTrigger);
    }

    private static boolean isThisActionAllowed(@Nullable class_1657 player, @NotNull String antiType, @NotNull Set<String> ids, @NotNull String id) {
        Tristate overridePermission = AntiBuildInitializer.getOverridePermission(player, antiType, id);
        if (overridePermission != Tristate.UNDEFINED) {
            return overridePermission.asBoolean();
        }
        if (AntiBuildInitializer.isAllowedByBypassPermission(player, antiType, id)) {
            return true;
        }
        return AntiBuildInitializer.isAllowedByConfigurationFile(ids, id);
    }

    private static boolean isAllowedByConfigurationFile(@NotNull Set<String> ids, @NotNull String id) {
        return !ids.contains(id) && !ids.contains("*");
    }

    private static Tristate getOverridePermission(@Nullable class_1657 player, @NotNull String antiType, @NotNull String id) {
        return Optional.ofNullable(player).map(p -> LuckpermsHelper.getPermission(player.method_5667(), ANTI_BUILD_OVERRIDE_PERMISSION, antiType, id)).orElse(Tristate.UNDEFINED);
    }

    private static boolean isAllowedByBypassPermission(@Nullable class_1657 player, @NotNull String antiType, @NotNull String id) {
        return Optional.ofNullable(player).map(p -> LuckpermsHelper.hasPermission(player.method_5667(), ANTI_BUILD_BYPASS_PERMISSION, antiType, id)).orElse(false);
    }

    @EventConsumer(injectorPriority=0)
    private static void consumePlayerBlockBreakPreEvent(PlayerBlockBreakPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        AntiBuildConfigModel.AntiTypes.BreakBlock config = AntiBuildInitializer.config.model().getAntiTypes().getBreakBlock();
        if (!config.isEnable()) {
            return;
        }
        class_2680 blockState = event.getWorld().method_8320(event.getBlockPos());
        String id = RegistryHelper.getIdAsString(blockState);
        AntiBuildInitializer.processAntiBuild((class_1657)event.getPlayer(), "break_block", config.getId(), id, event.getCallbackInfoReturnable(), false, () -> true);
    }

    @EventConsumer(injectorPriority=0)
    private static void consumePlayerInteractItemPreEvent(PlayerInteractItemPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        AntiBuildConfigModel.AntiTypes.InteractItem config = AntiBuildInitializer.config.model().getAntiTypes().getInteractItem();
        if (!config.isEnable()) {
            return;
        }
        String id = RegistryHelper.getIdAsString(event.getItemStack());
        AntiBuildInitializer.processAntiBuild((class_1657)event.getPlayer(), "interact_item", config.getId(), id, event.getCallbackInfoReturnable(), class_1269.field_5814, () -> true);
    }

    @EventConsumer(injectorPriority=0)
    private static void consumePlayerInteractBlockPreEvent(PlayerInteractBlockPreEvent event) {
        AntiBuildConfigModel.AntiTypes.InteractBlock config = AntiBuildInitializer.config.model().getAntiTypes().getInteractBlock();
        if (!config.isEnable()) {
            return;
        }
        class_2338 blockPos = event.getBlockHitResult().method_17777();
        class_2680 blockState = event.getWorld().method_8320(blockPos);
        String id = RegistryHelper.getIdAsString(blockState);
        AntiBuildInitializer.processAntiBuild((class_1657)event.getPlayer(), "interact_block", config.getId(), id, event.getCallbackInfoReturnable(), class_1269.field_5814, () -> true);
    }

    @EventConsumer(injectorPriority=0)
    private static void consumePlayerInteractEntityPreEvent(PlayerInteractEntityPreEvent event) {
        if (event.getCallbackInfoReturnable().isCancelled()) {
            return;
        }
        AntiBuildConfigModel.AntiTypes.InteractEntity config = AntiBuildInitializer.config.model().getAntiTypes().getInteractEntity();
        if (!config.isEnable()) {
            return;
        }
        String id = RegistryHelper.getIdAsString(event.getEntity());
        AntiBuildInitializer.processAntiBuild((class_1657)event.getPlayer(), "interact_entity", config.getId(), id, event.getCallbackInfoReturnable(), class_1269.field_5814, () -> event.getHand() == class_1268.field_5808);
    }
}

