/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import com.mojang.authlib.GameProfile;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import java.util.Optional;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3312;
import net.minecraft.class_8791;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EntityHelper {
    private static final String DIMENSION_NBT_KEY = "Dimension";

    public static boolean isRealPlayer(@NotNull class_3222 player) {
        return player.getClass() == class_3222.class;
    }

    private static void applyPlayerDataNbt(class_3222 player, @Nullable class_2487 playerDataNbt) {
        String dimensionId;
        class_3218 world;
        if (playerDataNbt == null) {
            return;
        }
        if (playerDataNbt.method_10545(DIMENSION_NBT_KEY) && (world = RegistryHelper.ofServerWorld(dimensionId = playerDataNbt.method_10558(DIMENSION_NBT_KEY))) != null) {
            player.method_51468(world);
        }
    }

    public static class_3222 loadOfflinePlayer(String playerName) {
        Optional<GameProfile> gameProfile = EntityHelper.getGameProfileByName(playerName);
        if (gameProfile.isEmpty()) {
            throw new IllegalArgumentException("can't find player %s in usercache.json".formatted(playerName));
        }
        class_3222 player = ServerHelper.getPlayerManager().method_14613(gameProfile.get(), class_8791.method_53821());
        Optional playerDataOpt = ServerHelper.getPlayerManager().method_14600(player);
        EntityHelper.applyPlayerDataNbt(player, playerDataOpt.orElse(null));
        return player;
    }

    private static Optional<GameProfile> getGameProfileByName(String playerName) {
        class_3312 userCache = ServerHelper.getServer().method_3793();
        if (userCache == null) {
            return Optional.empty();
        }
        return userCache.method_14515(playerName);
    }

    private EntityHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

