/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.auxiliary.minecraft;

import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.core.command.exception.AbortCommandExecutionException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class NbtHelper {
    private static <T extends class_2520> void setPath(@NotNull class_2487 root, @NotNull String path, T value) {
        String[] nodes = path.split("\\.");
        for (int i = 0; i < nodes.length - 1; ++i) {
            String node = nodes[i];
            if (!root.method_10545(node)) {
                root.method_10566(node, (class_2520)new class_2487());
            }
            root = root.method_10562(node);
        }
        String key = nodes[nodes.length - 1];
        root.method_10566(key, value);
    }

    public static <T extends class_2520> T withNbtElement(@NotNull class_2487 root, @NotNull String path, T orElse) {
        if (NbtHelper.readPath(root, path) == null) {
            NbtHelper.setPath(root, path, orElse);
        }
        return (T)NbtHelper.readPath(root, path);
    }

    @Nullable
    private static class_2520 readPath(@NotNull class_2487 root, @NotNull String path) {
        String[] nodes = path.split("\\.");
        for (int i = 0; i < nodes.length - 1; ++i) {
            String node = nodes[i];
            if (!root.method_10545(node)) {
                LogUtil.error("nbt {} don't has path {}", root, path);
            }
            root = root.method_10562(node);
        }
        String key = nodes[nodes.length - 1];
        return root.method_10580(key);
    }

    public static class_2499 writeSlotsNode(@NotNull class_2499 node, @NotNull List<class_1799> itemStackList) {
        for (class_1799 item : itemStackList) {
            node.add((Object)item.method_57375(RegistryHelper.getDefaultWrapperLookup()));
        }
        return node;
    }

    @NotNull
    public static List<class_1799> readSlotsNode(@Nullable class_2499 node) {
        if (node == null) {
            return new ArrayList<class_1799>();
        }
        ArrayList<class_1799> ret = new ArrayList<class_1799>();
        for (int i = 0; i < node.size(); ++i) {
            ret.add(class_1799.method_57359((class_7225.class_7874)RegistryHelper.getDefaultWrapperLookup(), (class_2487)node.method_10602(i)));
        }
        return ret;
    }

    public static void withNbtFile(@NotNull Path path, @NotNull Consumer<class_2487> function) {
        NbtHelper.withNbtFileAndGettingReturnValue(path, root -> {
            function.accept((class_2487)root);
            return null;
        });
    }

    public static <T> T withNbtFileAndGettingReturnValue(@NotNull Path path, @NotNull Function<class_2487, T> function) {
        class_2487 read;
        if (Files.notExists(path, new LinkOption[0])) {
            class_2507.method_10630((class_2487)new class_2487(), (Path)path);
        }
        if ((read = class_2507.method_10633((Path)path)) == null) {
            LogUtil.error("failed to read the nbt file in {}", path);
            throw new AbortCommandExecutionException();
        }
        T value = function.apply(read);
        class_2507.method_10630((class_2487)read, (Path)path);
        return value;
    }

    private NbtHelper() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

