/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.command.executor;

import com.mojang.brigadier.exceptions.CommandSyntaxException;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class CommandExecutor {
    public static void execute(@NotNull ExtendedCommandSource context, @NotNull List<String> commands) {
        commands.forEach(command -> CommandExecutor.execute(context, command));
    }

    public static int execute(@NotNull ExtendedCommandSource context, @NotNull String command) {
        command = context.expandCommand(command);
        try {
            return Objects.requireNonNull(ServerHelper.getCommandDispatcher()).execute(command, (Object)context.getExecutingSource());
        }
        catch (CommandSyntaxException e) {
            TextHelper.sendMessageByKey(context.getExecutingSource(), "command.execute.echo.executing_source", command, e.getMessage());
            if (!context.sameSource()) {
                TextHelper.sendMessageByKey(context.getInitiatingSource(), "command.execute.echo.initiating_source", command, context.getExecutingSource().method_9214(), e.getMessage());
            }
            return -1;
        }
    }

    private CommandExecutor() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

