/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.config.handler.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import io.github.sakurawald.Fuji;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceConfigurationHandler
extends BaseConfigurationHandler<JsonElement> {
    private final String resourcePath;

    private ResourceConfigurationHandler(Path path, String resourcePath) {
        super(path);
        this.resourcePath = resourcePath;
    }

    public ResourceConfigurationHandler(@NotNull String resourcePath) {
        this(Fuji.CONFIG_PATH.resolve(resourcePath), resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static JsonElement readJsonTreeFromResource(@NotNull String resourcePath) {
        JsonElement jsonElement;
        block7: {
            InputStream inputStream = Fuji.class.getResourceAsStream(resourcePath);
            if (inputStream == null) {
                throw new IllegalArgumentException("Resource not found: " + resourcePath);
            }
            BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
            try {
                jsonElement = JsonParser.parseReader((Reader)reader);
                if (Collections.singletonList(reader).get(0) == null) break block7;
            }
            catch (Throwable throwable) {
                if (Collections.singletonList(reader).get(0) != null) {
                    ((Reader)reader).close();
                }
                throw throwable;
            }
            ((Reader)reader).close();
        }
        return jsonElement;
    }

    private void mergeTree(JsonObject dataTree, JsonObject schemaTree) {
        schemaTree.keySet().stream().filter(key -> !dataTree.has(key)).forEach(key -> {
            LogUtil.debug("add missing language key `{}` for file `{}`", key, this.path);
            dataTree.add(key, schemaTree.get(key));
        });
    }

    @Override
    protected JsonElement getDefaultModel() {
        return ResourceConfigurationHandler.readJsonTreeFromResource(this.resourcePath);
    }

    @Override
    public void readStorage() {
        super.readStorage();
        if (this.model != null) {
            this.mergeTree(((JsonElement)this.model).getAsJsonObject(), this.getDefaultModel().getAsJsonObject());
            this.writeStorage();
        }
    }
}

