/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.config.transformer.abst;

import com.google.gson.JsonElement;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

public abstract class ConfigurationTransformer {
    private Path path;

    public void configure(Path path) {
        this.path = path;
    }

    public DocumentContext makeDocumentContext() {
        return BaseConfigurationHandler.getJsonPathParser().parse(this.path.toFile());
    }

    public abstract void apply();

    public boolean exists(DocumentContext context, String jsonPath) {
        try {
            context.read(jsonPath, new Predicate[0]);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean notExists(DocumentContext context, String jsonPath) {
        return !this.exists(context, jsonPath);
    }

    public void logConsole(String message, Object ... args) {
        Object[] fullArgs = new Object[args.length + 1];
        fullArgs[0] = this.path;
        System.arraycopy(args, 0, fullArgs, 1, args.length);
        LogUtil.warn("apply the transformer associated with the file `{}`\n => " + message, fullArgs);
    }

    public void writeStorage(DocumentContext context) {
        this.logConsole("write storage", new Object[0]);
        String json = BaseConfigurationHandler.getGson().toJson((JsonElement)context.json());
        Files.writeString(this.path, (CharSequence)json, new OpenOption[0]);
    }

    public Object read(DocumentContext context, String jsonPath) {
        return context.read(jsonPath, new Predicate[0]);
    }

    public void set(DocumentContext context, String jsonPath, Object newValue) {
        this.logConsole("set key `{}`: {}", jsonPath, newValue);
        context.set(jsonPath, newValue, new Predicate[0]);
    }

    public Path getPath() {
        return this.path;
    }
}

