/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.manager.impl.bossbar.structure;

import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.extension.PlayerCombatExtension;
import io.github.sakurawald.core.manager.impl.bossbar.BossBarTicket;
import io.github.sakurawald.core.manager.impl.bossbar.structure.Interruptible;
import io.github.sakurawald.core.structure.SpatialPose;
import java.util.List;
import net.minecraft.class_3213;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public abstract class InterruptibleTicket
extends BossBarTicket {
    @NotNull
    protected final class_3222 player;
    @NotNull
    protected final SpatialPose source;
    @NotNull
    protected final Interruptible interruptible;

    public InterruptibleTicket(class_3213 bossBar, int totalMS, @NotNull class_3222 player, @NotNull SpatialPose source, @NotNull Interruptible interruptible) {
        super(bossBar, totalMS, List.of(player));
        this.player = player;
        this.source = source;
        this.interruptible = interruptible;
    }

    @Override
    protected boolean preProgressChange() {
        if (!this.interruptible.isEnable()) {
            return true;
        }
        if (this.interruptible.isInterruptInCombat() && ((PlayerCombatExtension)this.player).fuji$inCombat()) {
            TextHelper.sendActionBarByKey(this.player, "teleport_warmup.in_combat", new Object[0]);
            return false;
        }
        double interruptDistance = this.getInterruptible().getInterruptDistance();
        return !(this.player.method_19538().method_1028(this.source.getX(), this.source.getY(), this.source.getZ()) >= interruptDistance * interruptDistance);
    }

    @NotNull
    public class_3222 getPlayer() {
        return this.player;
    }

    @NotNull
    public SpatialPose getSource() {
        return this.source;
    }

    @NotNull
    public Interruptible getInterruptible() {
        return this.interruptible;
    }
}

