/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.structure;

import io.github.sakurawald.core.auxiliary.LogUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.FileUtils;

public abstract class Downloader {
    private final URL url;
    private final Path destination;

    public Downloader(URL url, Path destination) {
        this.url = url;
        this.destination = destination;
    }

    public void start() {
        CompletableFuture.runAsync(() -> {
            try {
                LogUtil.info("start download file from {} to {}.", this.url, this.destination);
                FileUtils.copyURLToFile((URL)this.url, (File)this.destination.toFile());
                this.onComplete();
                LogUtil.info("end download file from {} to {}.", this.url, this.destination);
            }
            catch (IOException e) {
                LogUtil.error("failed to download file from {} to {}", this.url, this.destination);
            }
        });
    }

    public abstract void onComplete();
}

