/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.core.structure;

import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2709;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;

public class SpatialPose {
    private final String level;
    private final double x;
    private final double y;
    private final double z;
    private final float yaw;
    private final float pitch;

    private SpatialPose(String level, double x, double y, double z, float yaw, float pitch) {
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.yaw = yaw;
        this.pitch = pitch;
    }

    public SpatialPose(@NotNull class_1937 level, double x, double y, double z, float yaw, float pitch) {
        this(level.method_27983().method_29177().toString(), x, y, z, yaw, pitch);
    }

    @NotNull
    public static SpatialPose of(@NotNull class_3222 player) {
        return new SpatialPose(player.method_37908().method_27983().method_29177().toString(), player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
    }

    public boolean sameLevel(@NotNull class_1937 level) {
        return this.level.equals(level.method_27983().method_29177().toString());
    }

    public double distanceToSqr(@NotNull SpatialPose spatialPose) {
        if (!this.level.equals(spatialPose.level)) {
            return Double.MAX_VALUE;
        }
        double x = this.x - spatialPose.x;
        double y = this.y - spatialPose.y;
        double z = this.z - spatialPose.z;
        return x * x + y * y + z * z;
    }

    public void teleport(@NotNull class_3222 player, Set<class_2709> flags) {
        class_5321 worldKey = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)class_2960.method_60654((String)this.level));
        class_3218 serverLevel = ServerHelper.getServer().method_3847(worldKey);
        if (serverLevel == null) {
            TextHelper.sendMessageByKey(player, "world.dimension.not_found", this.level);
            return;
        }
        player.method_48105(serverLevel, this.x, this.y, this.z, flags, this.yaw, this.pitch, true);
    }

    public void teleport(@NotNull class_3222 player) {
        this.teleport(player, EnumSet.noneOf(class_2709.class));
    }

    public String getLevel() {
        return this.level;
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getZ() {
        return this.z;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getPitch() {
        return this.pitch;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SpatialPose)) {
            return false;
        }
        SpatialPose other = (SpatialPose)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getX(), other.getX()) != 0) {
            return false;
        }
        if (Double.compare(this.getY(), other.getY()) != 0) {
            return false;
        }
        if (Double.compare(this.getZ(), other.getZ()) != 0) {
            return false;
        }
        if (Float.compare(this.getYaw(), other.getYaw()) != 0) {
            return false;
        }
        if (Float.compare(this.getPitch(), other.getPitch()) != 0) {
            return false;
        }
        String this$level = this.getLevel();
        String other$level = other.getLevel();
        return !(this$level == null ? other$level != null : !this$level.equals(other$level));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SpatialPose;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $x = Double.doubleToLongBits(this.getX());
        result = result * 59 + (int)($x >>> 32 ^ $x);
        long $y = Double.doubleToLongBits(this.getY());
        result = result * 59 + (int)($y >>> 32 ^ $y);
        long $z = Double.doubleToLongBits(this.getZ());
        result = result * 59 + (int)($z >>> 32 ^ $z);
        result = result * 59 + Float.floatToIntBits(this.getYaw());
        result = result * 59 + Float.floatToIntBits(this.getPitch());
        String $level = this.getLevel();
        result = result * 59 + ($level == null ? 43 : $level.hashCode());
        return result;
    }

    public String toString() {
        return "SpatialPose(level=" + this.getLevel() + ", x=" + this.getX() + ", y=" + this.getY() + ", z=" + this.getZ() + ", yaw=" + this.getYaw() + ", pitch=" + this.getPitch() + ")";
    }

    public SpatialPose withLevel(String level) {
        return this.level == level ? this : new SpatialPose(level, this.x, this.y, this.z, this.yaw, this.pitch);
    }

    public SpatialPose withX(double x) {
        return this.x == x ? this : new SpatialPose(this.level, x, this.y, this.z, this.yaw, this.pitch);
    }

    public SpatialPose withY(double y) {
        return this.y == y ? this : new SpatialPose(this.level, this.x, y, this.z, this.yaw, this.pitch);
    }

    public SpatialPose withZ(double z) {
        return this.z == z ? this : new SpatialPose(this.level, this.x, this.y, z, this.yaw, this.pitch);
    }

    public SpatialPose withYaw(float yaw) {
        return this.yaw == yaw ? this : new SpatialPose(this.level, this.x, this.y, this.z, yaw, this.pitch);
    }

    public SpatialPose withPitch(float pitch) {
        return this.pitch == pitch ? this : new SpatialPose(this.level, this.x, this.y, this.z, this.yaw, pitch);
    }
}

