/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_alias;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_alias.config.model.CommandAliasConfigModel;
import io.github.sakurawald.module.initializer.command_alias.structure.CommandPathMappingNode;
import java.util.List;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.jetbrains.annotations.NotNull;

public class CommandAliasInitializer
extends ModuleInitializer {
    private static final BaseConfigurationHandler<CommandAliasConfigModel> config = new ObjectConfigurationHandler<CommandAliasConfigModel>("config.json", CommandAliasConfigModel.class);

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            CommandDispatcher<class_2168> dispatcher = ServerHelper.getCommandDispatcher();
            CommandAliasInitializer.config.model().alias.forEach(it -> {
                assert (dispatcher != null);
                this.processCommandAliasEntry(dispatcher, (CommandPathMappingNode)it);
            });
        });
    }

    private void processCommandAliasEntry(@NotNull CommandDispatcher<class_2168> dispatcher, @NotNull CommandPathMappingNode entry) {
        LiteralArgumentBuilder builder = null;
        CommandNode target = dispatcher.findNode(entry.getTo());
        for (int i = entry.getFrom().size() - 1; i >= 0; --i) {
            String name = entry.getFrom().get(i);
            if (builder == null) {
                if (target == null) {
                    LogUtil.warn("can't find the target command node for command alias entry: {}", entry);
                    return;
                }
                builder = (LiteralArgumentBuilder)class_2170.method_9247((String)name).redirect(target);
                continue;
            }
            builder = (LiteralArgumentBuilder)class_2170.method_9247((String)name).then(builder);
        }
        if (builder == null) {
            return;
        }
        CommandNode targetRoot = dispatcher.findNode(List.of(entry.getTo().getFirst()));
        if (targetRoot != null) {
            builder.requires(targetRoot.getRequirement());
        }
        dispatcher.register(builder);
    }
}

