/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_bundle.structure;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import io.github.sakurawald.core.command.argument.structure.Argument;
import io.github.sakurawald.core.command.executor.CommandExecutor;
import io.github.sakurawald.core.command.structure.CommandDescriptor;
import io.github.sakurawald.core.command.structure.CommandRequirementDescriptor;
import io.github.sakurawald.core.command.structure.ExtendedCommandSource;
import io.github.sakurawald.module.initializer.command_bundle.accessor.CommandContextAccessor;
import io.github.sakurawald.module.initializer.command_bundle.structure.BundleCommandNode;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class BundleCommandDescriptor
extends CommandDescriptor {
    private static final Pattern BUNDLE_COMMAND_DSL = Pattern.compile("([<](\\S+)\\s+(\\S+)[>])|(\\[(\\S+)\\s+(\\S+)\\s?([\\s\\S]*?)\\])|(\\S+)");
    private static final int LEXEME_GROUP_INDEX = 0;
    private static final int REQUIRED_NON_OPTIONAL_ARGUMENT_TYPE_GROUP_INDEX = 2;
    private static final int REQUIRED_NON_OPTIONAL_ARGUMENT_NAME_GROUP_INDEX = 3;
    private static final int REQUIRED_OPTIONAL_ARGUMENT_TYPE_GROUP_INDEX = 5;
    private static final int REQUIRED_OPTIONAL_ARGUMENT_NAME_GROUP_INDEX = 6;
    private static final int REQUIRED_OPTIONAL_ARGUMENT_DEFAULT_VALUE_GROUP_INDEX = 7;
    private static final int LITERAL_ARGUMENT_NAME_GROUP_INDEX = 8;
    private static final String ARGUMENT_NAME_PLACEHOLDER = "$";
    private final BundleCommandNode entry;
    private final Map<String, String> optionalArgumentName2DefaultValue;

    private BundleCommandDescriptor(Method method, List<Argument> arguments, BundleCommandNode entry, Map<String, String> optionalArgumentName2DefaultValue) {
        super(method, arguments);
        this.entry = entry;
        this.optionalArgumentName2DefaultValue = optionalArgumentName2DefaultValue;
    }

    private static Method getFunctionClosure() {
        Method functionClosure = BundleCommandDescriptor.class.getDeclaredMethod("executeBundleCommandClosure", CommandContext.class, BundleCommandDescriptor.class, List.class);
        functionClosure.setAccessible(true);
        return functionClosure;
    }

    private static int executeBundleCommandClosure(@NotNull CommandContext<class_2168> ctx, @NotNull BundleCommandDescriptor descriptor, @NotNull List<Object> args) {
        LogUtil.debug("the closure for `bundle command` associated with {} is invoked with args: ", descriptor.entry);
        args.forEach(arg -> LogUtil.debug("arg: {}", arg));
        List<String> commands = new ArrayList<String>(descriptor.entry.getBundle());
        HashMap<String, String> variables = new HashMap<String, String>();
        int argumentIndex = 0;
        for (Argument argument : descriptor.arguments) {
            if (argument.isLiteralArgument()) continue;
            String argumentName = argument.getArgumentName();
            String argumentValue = (String)args.get(argumentIndex);
            variables.put(argumentName, argumentValue);
            ++argumentIndex;
        }
        LogUtil.debug("fill the variables with: {}", variables);
        commands = commands.stream().map(command -> {
            String newCommand = command;
            for (Map.Entry variable : variables.entrySet()) {
                String oldStr = ARGUMENT_NAME_PLACEHOLDER + (String)variable.getKey();
                @NotNull String newStr = (String)variable.getValue();
                newCommand = newCommand.replace(oldStr, newStr);
            }
            return newCommand;
        }).toList();
        class_2168 source = (class_2168)ctx.getSource();
        commands = commands.stream().map(command -> TextHelper.parsePlaceholder(source, command)).toList();
        LogUtil.debug("execute bundle command: {}", commands);
        CommandExecutor.execute(ExtendedCommandSource.asConsole(source), commands);
        return 1;
    }

    public static BundleCommandDescriptor make(BundleCommandNode entry) {
        ArrayList<Argument> arguments = new ArrayList<Argument>();
        HashMap<String, String> defaultValueForOptionalArguments = new HashMap<String, String>();
        String pattern = entry.getPattern();
        CommandRequirementDescriptor requirement = entry.getRequirement();
        Matcher matcher = BUNDLE_COMMAND_DSL.matcher(pattern);
        int argumentIndex = 0;
        while (matcher.find()) {
            if (BundleCommandDescriptor.matchLiteralArgument(matcher)) {
                String argumentName = matcher.group(8);
                arguments.add(Argument.makeLiteralArgument(argumentName, requirement));
            } else {
                boolean isOptional = matcher.group(0).startsWith("[");
                if (isOptional) {
                    argumentType = matcher.group(5);
                    argumentName = matcher.group(6);
                    type = BaseArgumentTypeAdapter.toTypeClass(argumentType);
                    arguments.add(Argument.makeRequiredArgument(type, argumentName, true, requirement));
                    String defaultValue = matcher.group(7);
                    if (defaultValue == null) {
                        defaultValue = "";
                    }
                    defaultValueForOptionalArguments.put(argumentName, defaultValue);
                } else {
                    argumentType = matcher.group(2);
                    argumentName = matcher.group(3);
                    type = BaseArgumentTypeAdapter.toTypeClass(argumentType);
                    arguments.add(Argument.makeRequiredArgument(type, argumentName, false, requirement));
                }
            }
            ++argumentIndex;
        }
        return new BundleCommandDescriptor(BundleCommandDescriptor.getFunctionClosure(), arguments, entry, defaultValueForOptionalArguments);
    }

    private static boolean matchLiteralArgument(Matcher matcher) {
        return matcher.group(8) != null;
    }

    @Override
    protected List<Object> makeObjectsByArguments(CommandContext<class_2168> ctx) {
        ArrayList<Object> args = new ArrayList<Object>();
        CommandContextAccessor ctxAccessor = (CommandContextAccessor)ctx;
        for (Argument argument : this.collectArgumentsToMakeObjects()) {
            String arg;
            String argumentName = argument.getArgumentName();
            ParsedArgument parsedArgument = ctxAccessor.fuji$getArguments().get(argumentName);
            if (parsedArgument != null) {
                StringRange range = parsedArgument.getRange();
                arg = ctx.getInput().substring(range.getStart(), range.getEnd());
            } else {
                arg = this.optionalArgumentName2DefaultValue.get(argumentName);
            }
            args.add(arg);
        }
        LogUtil.debug("make args for bundle command: {}", args);
        return args;
    }

    @Override
    protected Command<class_2168> makeCommandFunctionClosure() {
        return ctx -> {
            int value;
            BundleCommandDescriptor descriptor = this;
            List<Object> args = this.makeObjectsByArguments((CommandContext<class_2168>)ctx);
            try {
                value = (Integer)this.method.invoke(null, ctx, descriptor, args);
            }
            catch (Exception e) {
                return BundleCommandDescriptor.handleException((CommandContext<class_2168>)ctx, this.method, e);
            }
            return value;
        };
    }

    public Map<String, String> getOptionalArgumentName2DefaultValue() {
        return this.optionalArgumentName2DefaultValue;
    }
}

