/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_meta.json;

import com.google.gson.JsonElement;
import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.Predicate;
import com.mojang.brigadier.context.CommandContext;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.command.argument.wrapper.impl.GreedyString;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_meta.json.command.argument.wrapper.JsonValueType;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.function.BiFunction;
import net.minecraft.class_2168;
import net.minecraft.class_2561;

@CommandNode(value="json")
@CommandRequirement(level=4)
public class JsonInitializer
extends ModuleInitializer {
    private static void operateJson(String filePath, BiFunction<DocumentContext, Path, Boolean> function) {
        block4: {
            Path path = Path.of(filePath, new String[0]);
            DocumentContext documentContext = BaseConfigurationHandler.getJsonPathParser().parse(path.toFile());
            Boolean destructiveFlag = function.apply(documentContext, path);
            if (!destructiveFlag.booleanValue()) break block4;
            String json = BaseConfigurationHandler.getGson().toJson((JsonElement)documentContext.json());
            try {
                Files.writeString(path, (CharSequence)json, new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @CommandNode(value="read")
    private static int read(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            Object read = documentContext.read(jsonPath, new Predicate[0]);
            ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)read.toString()));
            return false;
        });
        return 1;
    }

    @CommandNode(value="write")
    private static int write(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath, JsonValueType valueType, GreedyString value) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            Object obj = valueType.parse((String)value.getValue());
            documentContext.set(jsonPath, obj, new Predicate[0]);
            return true;
        });
        return 1;
    }

    @CommandNode(value="delete")
    private static int delete(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            documentContext.delete(jsonPath, new Predicate[0]);
            return true;
        });
        return 1;
    }

    @CommandNode(value="put")
    private static int put(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath, String jsonKey, JsonValueType valueType, GreedyString value) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            Object obj = valueType.parse((String)value.getValue());
            documentContext.put(jsonPath, jsonKey, obj, new Predicate[0]);
            return true;
        });
        return 1;
    }

    @CommandNode(value="renameKey")
    private static int renameKey(@CommandSource CommandContext<class_2168> ctx, String filePath, String jsonPath, String oldJsonKey, String newJsonKey) {
        JsonInitializer.operateJson(filePath, (documentContext, path) -> {
            documentContext.renameKey(jsonPath, oldJsonKey, newJsonKey, new Predicate[0]);
            return true;
        });
        return 1;
    }
}

