/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_permission;

import io.github.sakurawald.core.annotation.Cite;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.minecraft.CommandHelper;
import io.github.sakurawald.core.auxiliary.minecraft.PermissionHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandRequirement;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.core.structure.CommandNodeWrapper;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.command_permission.gui.CommandPermissionGui;
import io.github.sakurawald.module.initializer.command_permission.structure.CommandNodePermission;
import io.github.sakurawald.module.initializer.command_permission.structure.WrappedPredicate;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

@Cite(value={"https://github.com/DrexHD/VanillaPermissions"})
@CommandNode(value="command-permission")
@CommandRequirement(level=4)
public class CommandPermissionInitializer
extends ModuleInitializer {
    public static boolean verboseMode = false;

    @CommandNode(value="gui")
    @Document(value="Open the command permission gui.")
    public static int gui(@CommandSource class_3222 player) {
        List<CommandNodePermission> entities = CommandHelper.getCommandNodes().stream().map(CommandNodePermission::new).sorted(Comparator.comparing(CommandNodeWrapper::getPath)).toList();
        new CommandPermissionGui(player, entities, 0).open();
        return 1;
    }

    @CommandNode(value="verbose")
    @Document(value="Toggle the command permission verbose mode.")
    public static int verbose(@CommandSource class_2168 source) {
        verboseMode = !verboseMode;
        CommandHelper.Return.outputBoolean(source, verboseMode);
        return 1;
    }

    public static String computeCommandPermission(String commandPath) {
        return "fuji.permission.%s".formatted(commandPath);
    }

    private static void tryVerboseMode(class_2168 source, String commandPath, String requiredPermissionToExecuteThisCommand, Tristate state) {
        if (!verboseMode) {
            return;
        }
        String description = CommandPermissionInitializer.makeDescription(state);
        LogUtil.info("Command Source = {}\nCommand Path of the Target Command = {}\nThe permission used by Luckperms to calculate whether the command source can use the target command = {}\nLuckPerms Permission Calculation Result = {}\nDescription = {}\n", source.method_9214(), commandPath, requiredPermissionToExecuteThisCommand, state, description);
    }

    @NotNull
    private static String makeDescription(Tristate state) {
        String description = null;
        description = state == Tristate.UNDEFINED ? "The result is UNDEFINED, it means command_permission module WILL NOT HANDLE this command. We simply fallback the requirement predicate of this command to its original predicate." : (state == Tristate.TRUE ? "The result is TRUE, it means command_permission module WILL ALLOW the command source to use this command." : (state == Tristate.FALSE ? "The result is FALSE, it means command_permission module WILL DIS-ALLOW the command source to use this command." : "I don't know why, but the value of Tristate is un-expected."));
        return description;
    }

    @NotNull
    public static WrappedPredicate<class_2168> makeWrappedPredicate(String commandPath, @NotNull Predicate<class_2168> original) {
        return source -> {
            if (source.method_44023() == null) {
                return original.test((class_2168)source);
            }
            try {
                String permission = CommandPermissionInitializer.computeCommandPermission(commandPath);
                Tristate triState = PermissionHelper.getPermission(source.method_44023().method_5667(), permission);
                CommandPermissionInitializer.tryVerboseMode(source, commandPath, permission, triState);
                if (triState != Tristate.UNDEFINED) {
                    return triState.asBoolean();
                }
                return original.test((class_2168)source);
            }
            catch (Throwable use_original_predicate_if_failed) {
                return original.test((class_2168)source);
            }
        };
    }

    private static void ensureCommandNodeRequirementIsWrapped() {
        CommandHelper.getCommandNodes().forEach(com.mojang.brigadier.tree.CommandNode::getRequirement);
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> CommandPermissionInitializer.ensureCommandNodeRequirementIsWrapped());
    }
}

