/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.command_permission.gui;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.PagedGui;
import io.github.sakurawald.module.initializer.command_permission.CommandPermissionInitializer;
import io.github.sakurawald.module.initializer.command_permission.structure.CommandNodePermission;
import java.util.List;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommandPermissionGui
extends PagedGui<CommandNodePermission> {
    public CommandPermissionGui(class_3222 player, @NotNull List<CommandNodePermission> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "command_permission.list.gui.title", new Object[0]), entities, pageIndex);
        this.getFooter().setSlot(4, (GuiElementBuilderInterface)GuiHelper.makeHelpButton(player).setLore(TextHelper.getTextListByKey(player, "command_permission.list.gui.help.lore")));
    }

    @Override
    protected PagedGui<CommandNodePermission> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<CommandNodePermission> entities, int pageIndex) {
        return new CommandPermissionGui(player, entities, pageIndex);
    }

    @Override
    protected GuiElementInterface toGuiElement(CommandNodePermission entity) {
        List<class_2561> lore = List.of(TextHelper.getTextByKey(this.getPlayer(), "command_permission.list.gui.entry.lore", entity.isWrapped()));
        return new GuiElementBuilder().setItem(entity.isWrapped() ? class_1802.field_8734 : class_1802.field_8636).setName((class_2561)class_2561.method_43470((String)entity.getPath())).setCallback((index, clickType, actionType) -> {
            String commandPath = entity.getPath();
            String commandPermission = CommandPermissionInitializer.computeCommandPermission(commandPath);
            if (clickType.isLeft) {
                String executionCommand = "/lp group default permission set %s true".formatted(commandPermission);
                TextHelper.sendMessageByKey(this.getPlayer(), "command_permission.command.set_true", commandPath, executionCommand, executionCommand);
            } else if (clickType.isRight) {
                String executionCommand = "/lp group default permission set %s false".formatted(commandPermission);
                TextHelper.sendMessageByKey(this.getPlayer(), "command_permission.command.set_false", commandPath, executionCommand, executionCommand);
            } else if (clickType.isMiddle) {
                String executionCommand = "/lp group default permission unset %s".formatted(commandPermission);
                TextHelper.sendMessageByKey(this.getPlayer(), "command_permission.command.unset", commandPath, executionCommand, executionCommand);
            }
            this.close();
        }).setLore(lore).build();
    }

    @Override
    protected List<CommandNodePermission> filter(String keyword) {
        return this.getEntities().stream().filter((? super T it) -> it.getPath().contains(keyword)).toList();
    }
}

