/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.fuji.gui;

import com.mojang.authlib.GameProfile;
import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SimpleGui;
import io.github.sakurawald.core.auxiliary.minecraft.GuiHelper;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.gui.PagedGui;
import io.github.sakurawald.core.service.gameprofile_fetcher.MojangProfileFetcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.metadata.ContactInformation;
import net.fabricmc.loader.api.metadata.ModMetadata;
import net.fabricmc.loader.api.metadata.Person;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_9290;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AboutGui
extends PagedGui<Person> {
    public AboutGui(class_3222 player, @NotNull List<Person> entities, int pageIndex) {
        super(null, player, TextHelper.getTextByKey(player, "about", new Object[0]), entities, pageIndex);
        ModMetadata metadata = ((ModContainer)FabricLoader.getInstance().getModContainer("fuji").get()).getMetadata();
        this.getFooter().setSlot(1, (GuiElementBuilderInterface)new GuiElementBuilder(class_1802.field_8529).setName(TextHelper.getTextByKey(player, "version.format", metadata.getVersion().getFriendlyString())));
        this.getFooter().setSlot(4, new GuiElementBuilder(class_1802.field_8137).setName(TextHelper.getTextByKey(player, "homepage.project", new Object[0])).setCallback(() -> {
            TextHelper.sendMessageByKey(player, "homepage.project.visit", metadata.getContact().get("sources").orElse("can't read project homepage from metadata"));
            this.close();
        }));
    }

    @Override
    protected void drawPagedGui() {
        super.drawPagedGui();
        this.fetchHeads();
    }

    private void fetchHeads() {
        int i = 0;
        while (i < 54) {
            GuiElementInterface slot = this.getSlot(i);
            if (slot == null) {
                return;
            }
            int finalI = i++;
            CompletableFuture.runAsync(() -> {
                class_1799 itemStack = slot.getItemStack();
                String onlinePlayerName = itemStack.method_7964().getString().trim();
                GameProfile gameProfile = MojangProfileFetcher.makeOnlineGameProfile(onlinePlayerName);
                GuiElementBuilder builder = new GuiElementBuilder().setItem(itemStack.method_7909()).setName(itemStack.method_7964()).setCallback(slot.getGuiCallback()).setSkullOwner(gameProfile, ServerHelper.getServer());
                class_9290 loreComponent = (class_9290)itemStack.method_57824(class_9334.field_49632);
                if (loreComponent != null) {
                    builder.setLore(loreComponent.comp_2400());
                }
                this.setSlot(finalI, (GuiElementBuilderInterface)builder);
                this.draw();
            });
        }
    }

    @Override
    protected PagedGui<Person> make(@Nullable SimpleGui parent, class_3222 player, class_2561 title, @NotNull List<Person> entities, int pageIndex) {
        return new AboutGui(player, entities, pageIndex);
    }

    private boolean isUrl(String string) {
        return string.contains("http://") || string.contains("https://");
    }

    public GuiElementInterface.ClickCallback makeCallback(Person entity) {
        return (a, b, c, d) -> {
            class_5250 text = class_2561.method_43473();
            text.method_10852(TextHelper.getTextByKey(this.getPlayer(), "contact.visit.name", entity.getName())).method_10852(TextHelper.TEXT_NEWLINE);
            entity.getContact().asMap().forEach((k, v) -> text.method_10852(TextHelper.getTextByKey(this.getPlayer(), this.isUrl((String)v) ? "contact.visit.entry.is_url" : "contact.visit.entry.is_not_url", k, v, v)).method_10852(TextHelper.TEXT_NEWLINE));
            this.getPlayer().method_64398((class_2561)text);
            this.close();
        };
    }

    public List<class_2561> makeTextListFromContact(ContactInformation contact) {
        ArrayList<class_2561> ret = new ArrayList<class_2561>();
        contact.asMap().forEach((k, v) -> ret.add(TextHelper.getTextByKey(this.getPlayer(), "contact.entry", k, v)));
        ret.add(TextHelper.getTextByKey(this.getPlayer(), "contact.click.prompt", new Object[0]));
        return ret;
    }

    @Override
    protected GuiElementInterface toGuiElement(Person entity) {
        return GuiHelper.makeUnknownPlayerSkull().setName(TextHelper.getTextByKey(this.getPlayer(), "contact.name", entity.getName())).setLore(this.makeTextListFromContact(entity.getContact())).setCallback(this.makeCallback(entity)).build();
    }

    @Override
    protected List<Person> filter(String keyword) {
        return this.getEntities().stream().filter((? super T e) -> {
            Map contact = e.getContact().asMap();
            return e.getName().contains(keyword) || contact.entrySet().stream().anyMatch(it -> ((String)it.getKey()).contains(keyword) || ((String)it.getValue()).contains(keyword));
        }).toList();
    }
}

