/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.gameplay.carpet.fake_player_manager;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import io.github.sakurawald.core.annotation.Document;
import io.github.sakurawald.core.auxiliary.ChronosUtil;
import io.github.sakurawald.core.auxiliary.minecraft.ServerHelper;
import io.github.sakurawald.core.auxiliary.minecraft.TextHelper;
import io.github.sakurawald.core.command.annotation.CommandNode;
import io.github.sakurawald.core.command.annotation.CommandSource;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.config.handler.impl.ObjectConfigurationHandler;
import io.github.sakurawald.core.event.impl.ServerLifecycleEvents;
import io.github.sakurawald.module.initializer.ModuleInitializer;
import io.github.sakurawald.module.initializer.gameplay.carpet.fake_player_manager.config.model.FakePlayerManagerConfigModel;
import io.github.sakurawald.module.initializer.gameplay.carpet.fake_player_manager.job.ManageFakePlayersJob;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;

public class FakePlayerManagerInitializer
extends ModuleInitializer {
    public static final BaseConfigurationHandler<FakePlayerManagerConfigModel> config = new ObjectConfigurationHandler<FakePlayerManagerConfigModel>("config.json", FakePlayerManagerConfigModel.class);
    private static final Map<String, List<String>> player2fakePlayers = new HashMap<String, List<String>>();
    private static final Map<String, Long> player2expiration = new HashMap<String, Long>();

    public static void checkCapsLimit() {
        FakePlayerManagerInitializer.invalidFakePlayers();
        int capsLimit = FakePlayerManagerInitializer.computeFakePlayerCapsLimit();
        long currentTimeMs = System.currentTimeMillis();
        player2fakePlayers.entrySet().forEach(e -> {
            String ownerPlayerName = (String)e.getKey();
            long expiration = player2expiration.computeIfAbsent(ownerPlayerName, k -> 0L);
            Integer[] allowFakePlayers = new Integer[]{0};
            List newValue = ((List)e.getValue()).stream().filter(fakePlayerName -> {
                class_3222 fakePlayer = ServerHelper.getPlayerByNameIgnoreCase(fakePlayerName);
                if (fakePlayer == null) {
                    return false;
                }
                if (currentTimeMs >= expiration) {
                    class_3222 owner = ServerHelper.getPlayerByNameIgnoreCase(ownerPlayerName);
                    if (owner != null) {
                        FakePlayerManagerInitializer.renewMyFakePlayers(owner);
                        return true;
                    }
                    fakePlayer.method_5768(fakePlayer.method_51469());
                    TextHelper.sendBroadcastByKey("fake_player_manager.kick_for_expiration", fakePlayer.method_7334().getName(), ownerPlayerName);
                    return false;
                }
                if (allowFakePlayers[0] < capsLimit) {
                    Integer n = allowFakePlayers[0];
                    allowFakePlayers[0] = allowFakePlayers[0] + 1;
                    return true;
                }
                fakePlayer.method_5768(fakePlayer.method_51469());
                TextHelper.sendBroadcastByKey("fake_player_manager.kick_for_amount", fakePlayer.method_7334().getName(), ownerPlayerName);
                return false;
            }).collect(Collectors.toList());
            e.setValue(newValue);
        });
    }

    @CommandNode(value="player renew")
    @Document(value="Renew the expiration time of all fake-players spawned by you.")
    private static int $renew(@CommandSource class_3222 player) {
        FakePlayerManagerInitializer.renewMyFakePlayers(player);
        return 1;
    }

    @CommandNode(value="player who")
    @Document(value="List all fake-players and its owner.")
    private static int $who(@CommandSource CommandContext<class_2168> context) {
        StringBuilder body = new StringBuilder();
        player2fakePlayers.forEach((k, v) -> body.append("%s -> %s".formatted(k, v)).append("\n"));
        class_2168 source = (class_2168)context.getSource();
        source.method_45068((class_2561)TextHelper.getTextByKey(source, "fake_player_manager.who.header", new Object[0]).method_27661().method_10852((class_2561)class_2561.method_43470((String)body.toString())));
        return 1;
    }

    public static void renewMyFakePlayers(@NotNull class_3222 player) {
        int renewDuration = FakePlayerManagerInitializer.config.model().renew_duration_ms;
        long newExpiration = System.currentTimeMillis() + (long)renewDuration;
        player2expiration.put(player.method_7334().getName(), newExpiration);
        TextHelper.sendMessageByKey(player, "fake_player_manager.renew.success", ChronosUtil.toStandardDateFormat(newExpiration));
    }

    public static void invalidFakePlayers() {
        player2fakePlayers.values().forEach(value -> value.removeIf(fakePlayerName -> {
            class_3222 fakePlayer = ServerHelper.getPlayerByNameIgnoreCase(fakePlayerName);
            return fakePlayer == null || fakePlayer.method_31481();
        }));
    }

    public static boolean canSpawnFakePlayer(@NotNull class_3222 player) {
        int capsLimit = FakePlayerManagerInitializer.computeFakePlayerCapsLimit();
        int currentQuantity = player2fakePlayers.computeIfAbsent(player.method_7334().getName(), k -> new ArrayList()).size();
        return currentQuantity < capsLimit;
    }

    public static void addMyFakePlayer(@NotNull class_3222 player, @NotNull String fakePlayer) {
        player2fakePlayers.computeIfAbsent(player.method_7334().getName(), k -> new ArrayList()).add(fakePlayer);
    }

    public static boolean isMyFakePlayer(@NotNull class_3222 player, @NotNull String fakePlayer) {
        List myFakePlayers = player2fakePlayers.computeIfAbsent(player.method_7334().getName(), k -> new ArrayList());
        return myFakePlayers.stream().anyMatch(it -> it.equalsIgnoreCase(fakePlayer));
    }

    public static boolean isMyFakePlayer(@NotNull class_3222 player, @NotNull class_3222 fakePlayer) {
        return FakePlayerManagerInitializer.isMyFakePlayer(player, fakePlayer.method_7334().getName());
    }

    public static boolean canManipulateFakePlayer(@NotNull CommandContext<class_2168> ctx, String fakePlayer) {
        if (((ParsedCommandNode)ctx.getNodes().get(2)).getNode().getName().equals("shadow")) {
            return false;
        }
        class_3222 player = ((class_2168)ctx.getSource()).method_44023();
        if (player == null) {
            return true;
        }
        if (((class_2168)ctx.getSource()).method_9259(4)) {
            return true;
        }
        return FakePlayerManagerInitializer.isMyFakePlayer(player, fakePlayer);
    }

    public static int computeFakePlayerCapsLimit() {
        int currentDays = LocalDate.now().getDayOfWeek().getValue();
        LocalTime currentTime = LocalTime.now();
        int currentMinutes = currentTime.getHour() * 60 + currentTime.getMinute();
        Optional<List> first = FakePlayerManagerInitializer.config.model().caps_limit_rule.stream().filter(it -> currentDays >= (Integer)it.get(0) && currentMinutes >= (Integer)it.get(1)).findFirst();
        if (first.isPresent()) {
            return (Integer)first.get().get(2);
        }
        return -1;
    }

    @Override
    protected void onInitialize() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> new ManageFakePlayersJob().schedule());
    }
}

