/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.module.initializer.head.privoder;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import io.github.sakurawald.core.auxiliary.LogUtil;
import io.github.sakurawald.core.auxiliary.ReflectionUtil;
import io.github.sakurawald.core.config.handler.abst.BaseConfigurationHandler;
import io.github.sakurawald.core.structure.Downloader;
import io.github.sakurawald.module.initializer.head.HeadInitializer;
import io.github.sakurawald.module.initializer.head.structure.Category;
import io.github.sakurawald.module.initializer.head.structure.Head;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.concurrent.atomic.AtomicReference;

public final class HeadProvider {
    private static final Path HEAD_DATA_DIR_PATH = ReflectionUtil.computeModuleConfigPath(HeadInitializer.class).resolve("head-data").toAbsolutePath();
    private static final String HEAD_DATABASE_API = "https://minecraft-heads.com/scripts/api.php?cat=%s&tags=true";
    private static final AtomicReference<Object> loadedHeads = new AtomicReference();

    private static Path computePath(Category category) {
        return HEAD_DATA_DIR_PATH.resolve(category.name + ".json");
    }

    public static Multimap<Category, Head> fetchData() {
        final HashMultimap result = HashMultimap.create();
        for (final Category category : Category.values()) {
            String URL2 = null;
            try {
                Path destination = HeadProvider.computePath(category);
                if (Files.exists(destination, new LinkOption[0])) {
                    HeadProvider.loadCategory((HashMultimap<Category, Head>)result, category);
                    continue;
                }
                URL2 = HEAD_DATABASE_API.formatted(category.name);
                URI uri = URI.create(URL2);
                Downloader downloader = new Downloader(uri.toURL(), destination){

                    @Override
                    public void onComplete() {
                        HeadProvider.loadCategory((HashMultimap<Category, Head>)result, category);
                    }
                };
                downloader.start();
            }
            catch (IOException e) {
                LogUtil.warn("failed to download heads from URL {}", URL2);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadCategory(HashMultimap<Category, Head> result, Category category) {
        try {
            LogUtil.debug("load head category: {}", category.name);
            Path path = HeadProvider.computePath(category);
            InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]));
            try {
                JsonArray headsJson = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                for (JsonElement headJson : headsJson) {
                    try {
                        Head head = (Head)BaseConfigurationHandler.getGson().fromJson(headJson, Head.class);
                        result.put((Object)category, (Object)head);
                    }
                    catch (Exception e) {
                        LogUtil.warn("invalid head: " + String.valueOf(headJson), new Object[0]);
                    }
                }
            }
            finally {
                if (Collections.singletonList(reader).get(0) != null) {
                    reader.close();
                }
            }
        }
        catch (IOException e) {
            LogUtil.error("failed to load head category.", e);
        }
    }

    private HeadProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Multimap<Category, Head> getLoadedHeads() {
        AtomicReference<Object> value = loadedHeads.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = loadedHeads;
            synchronized (atomicReference) {
                value = loadedHeads.get();
                if (value == null) {
                    Multimap<Category, Head> actualValue = HeadProvider.fetchData();
                    value = actualValue == null ? loadedHeads : actualValue;
                    loadedHeads.set(value);
                }
            }
        }
        return (Multimap)(value == loadedHeads ? null : value);
    }
}

